/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.nav.hierarchy;

import java.awt.BorderLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.parsing.api.indexing.IndexingManager;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.nav.hierarchy.ClassHierarchyPanel;
import org.netbeans.modules.php.editor.nav.hierarchy.ShowPhpClassHierarchyAction;
import org.openide.awt.Mnemonics;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Union2;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

@SuppressWarnings(value={"SE_NO_SUITABLE_CONSTRUCTOR_FOR_EXTERNALIZATION"})
final class PhpHierarchyTopComponent
extends TopComponent
implements PropertyChangeListener {
    private static PhpHierarchyTopComponent instance;
    static final String ICON_PATH = "org/netbeans/modules/php/editor/resources/subtypehierarchy.gif";
    private static final String PREFERRED_ID = "PhpHierarchyTopComponent";
    private JComponent last = null;
    private RequestProcessor requestProcessor;
    private RequestProcessor.Task task;
    private JButton jButton1;

    private PhpHierarchyTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(this.getClass(), (String)"CTL_HierarchyTopComponent"));
        this.setToolTipText(NbBundle.getMessage(this.getClass(), (String)"HINT_HierarchyTopComponent"));
        this.setIcon(ImageUtilities.loadImage((String)ICON_PATH, (boolean)true));
        this.putClientProperty("KeepNonPersistentTCInModelWhenClosed", Boolean.TRUE);
    }

    private void setModel(Model model) {
        FileObject fileObject = model.getFileScope().getFileObject();
        this.setName((String)(fileObject == null ? "?" : fileObject.getNameExt() + " - " + NbBundle.getMessage(this.getClass(), (String)"CTL_HierarchyTopComponent")));
        this.setToolTipText(NbBundle.getMessage(this.getClass(), (String)"HINT_HierarchyTopComponent"));
        if (!(this.last instanceof ClassHierarchyPanel)) {
            this.removeAll();
            ClassHierarchyPanel panel = new ClassHierarchyPanel(true);
            this.add(panel, "Center");
            this.validate();
            this.last = panel;
        }
        ((ClassHierarchyPanel)this.last).setModel(model);
    }

    public void requestActive() {
        super.requestActive();
        if (this.last != null) {
            this.last.requestFocusInWindow();
        }
    }

    private void initComponents() {
        this.jButton1 = new JButton();
        this.setLayout(new BorderLayout());
        this.jButton1.setBackground(new JTextArea().getBackground());
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(PhpHierarchyTopComponent.class, (String)"NoViewAvailable"));
        this.jButton1.setBorderPainted(false);
        this.jButton1.setEnabled(false);
        this.add(this.jButton1, "Center");
    }

    public static synchronized PhpHierarchyTopComponent getDefault() {
        if (instance == null) {
            instance = new PhpHierarchyTopComponent();
        }
        return instance;
    }

    public static synchronized PhpHierarchyTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(PhpHierarchyTopComponent.class.getName()).warning("Cannot find PhpHierarchyTopComponent component. It will not be located properly in the window system.");
            return PhpHierarchyTopComponent.getDefault();
        }
        if (win instanceof PhpHierarchyTopComponent) {
            return (PhpHierarchyTopComponent)win;
        }
        Logger.getLogger(PhpHierarchyTopComponent.class.getName()).warning("There seem to be multiple components with the 'PhpHierarchyTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return PhpHierarchyTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 1;
    }

    public void componentOpened() {
        TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void componentClosed() {
        this.removeAll();
        this.initComponents();
        this.last = null;
        TopComponent.getRegistry().removePropertyChangeListener((PropertyChangeListener)this);
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        PhpHierarchyTopComponent view;
        if ((this.isOpened() && evt.getPropertyName() == null || evt.getPropertyName().equals("activatedNodes")) && (view = PhpHierarchyTopComponent.findInstance()) != null && view.isOpened()) {
            this.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refresh() {
        PhpHierarchyTopComponent phpHierarchyTopComponent = this;
        synchronized (phpHierarchyTopComponent) {
            if (this.requestProcessor == null) {
                this.requestProcessor = new RequestProcessor("RefreshHierarchyScheduler");
                this.task = this.requestProcessor.create(new Runnable(){

                    @Override
                    public void run() {
                        boolean indexing = IndexingManager.getDefault().isIndexing();
                        if (!indexing) {
                            try {
                                Model model;
                                final ArrayList fromNode = new ArrayList();
                                SwingUtilities.invokeAndWait(new Runnable(){

                                    @Override
                                    public void run() {
                                        Node[] activatedNodes = TopComponent.getRegistry().getActivatedNodes();
                                        if (activatedNodes.length > 0) {
                                            EditorCookie c = (EditorCookie)activatedNodes[0].getLookup().lookup(EditorCookie.class);
                                            if (ShowPhpClassHierarchyAction.isFromEditor(c)) {
                                                Union2 first = Union2.createFirst((Object)c.getOpenedPanes()[0].getDocument());
                                                fromNode.add(first);
                                            } else {
                                                FileObject fo;
                                                DataObject dobj = (DataObject)activatedNodes[0].getLookup().lookup(DataObject.class);
                                                FileObject fileObject = fo = dobj != null ? dobj.getPrimaryFile() : null;
                                                if (fo != null && fo.isData() && FileUtils.isPhpFile((FileObject)fo)) {
                                                    Union2 second = Union2.createSecond((Object)fo);
                                                    fromNode.add(second);
                                                }
                                            }
                                        }
                                    }
                                });
                                if (fromNode.size() > 0 && (model = ShowPhpClassHierarchyAction.getModel((Union2<Document, FileObject>)((Union2)fromNode.get(0)))) != null) {
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            PhpHierarchyTopComponent.this.setModel(model);
                                        }
                                    });
                                }
                            }
                            catch (InterruptedException | InvocationTargetException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        } else {
                            PhpHierarchyTopComponent.this.task.cancel();
                            PhpHierarchyTopComponent.this.task.schedule(500);
                        }
                    }
                });
            }
        }
        this.task.cancel();
        this.task.schedule(500);
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return PhpHierarchyTopComponent.getDefault();
        }
    }
}

