/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.php.api.PhpVersion;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.BodyDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreationVariable;
import org.netbeans.modules.php.editor.parser.astnodes.FieldsDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.netbeans.modules.php.editor.verification.UnhandledErrorRule;
import org.netbeans.modules.php.editor.verification.VerificationError;
import org.openide.filesystems.FileObject;

public final class PHP84UnhandledError
extends UnhandledErrorRule {
    public String getDisplayName() {
        return Bundle.PHP84UnhandledError_displayName();
    }

    @Override
    public void invoke(PHPRuleContext context, List<Error> errors) {
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() == null) {
            return;
        }
        FileObject fileObject = phpParseResult.getSnapshot().getSource().getFileObject();
        if (fileObject != null && PHP84UnhandledError.appliesTo(fileObject)) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            CheckVisitor checkVisitor = new CheckVisitor(fileObject);
            phpParseResult.getProgram().accept(checkVisitor);
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            errors.addAll(checkVisitor.getErrors());
        }
    }

    private static boolean appliesTo(FileObject fileObject) {
        return CodeUtils.isPhpVersionLessThan(fileObject, PhpVersion.PHP_84);
    }

    private static final class CheckVisitor
    extends DefaultVisitor {
        private final List<VerificationError> errors = new ArrayList<VerificationError>();
        private final FileObject fileObject;

        public CheckVisitor(FileObject fileObject) {
            this.fileObject = fileObject;
        }

        public Collection<VerificationError> getErrors() {
            return Collections.unmodifiableCollection(this.errors);
        }

        @Override
        public void visit(ClassInstanceCreationVariable node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.createError(node);
            super.visit(node);
        }

        @Override
        public void visit(FieldsDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.checkSetVisibility(node);
            this.checkFinalProperty(node);
            super.visit(node);
        }

        private void checkSetVisibility(FieldsDeclaration node) {
            if (BodyDeclaration.Modifier.isSetVisibilityModifier(node.getModifier())) {
                this.createError(node);
            }
        }

        private void checkFinalProperty(FieldsDeclaration node) {
            if (BodyDeclaration.Modifier.isFinal(node.getModifier())) {
                this.createError(node);
            }
        }

        @Override
        public void visit(MethodDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.checkSetVisibility(node);
            super.visit(node);
        }

        private void checkSetVisibility(MethodDeclaration node) {
            if (CodeUtils.isConstructor(node)) {
                FunctionDeclaration function = node.getFunction();
                for (FormalParameter formalParameter : function.getFormalParameters()) {
                    if (CancelSupport.getDefault().isCancelled()) {
                        return;
                    }
                    if (!BodyDeclaration.Modifier.isSetVisibilityModifier(formalParameter.getModifier())) continue;
                    this.createError(formalParameter);
                }
            }
        }

        private void createError(ASTNode node) {
            this.createError(node.getStartOffset(), node.getEndOffset());
        }

        private void createError(OffsetRange offsetRange) {
            this.errors.add(new PHP84VersionError(this.fileObject, offsetRange.getStart(), offsetRange.getEnd()));
        }

        private void createError(int startOffset, int endOffset) {
            this.errors.add(new PHP84VersionError(this.fileObject, startOffset, endOffset));
        }
    }

    private static final class PHP84VersionError
    extends VerificationError {
        private static final String KEY = "Php.Version.84";

        private PHP84VersionError(FileObject fileObject, int startOffset, int endOffset) {
            super(fileObject, startOffset, endOffset);
        }

        public String getDisplayName() {
            return Bundle.PHP83VersionError_displayName();
        }

        public String getDescription() {
            return Bundle.PHP83VersionError_description();
        }

        public String getKey() {
            return KEY;
        }
    }
}

