/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.monitor.data;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Vector;
import org.netbeans.modules.schema2beans.BaseBean;
import org.netbeans.modules.schema2beans.BeanComparator;
import org.netbeans.modules.schema2beans.BeanProp;
import org.netbeans.modules.schema2beans.GraphManager;
import org.netbeans.modules.schema2beans.Version;
import org.netbeans.modules.web.monitor.data.ClientData;
import org.netbeans.modules.web.monitor.data.ContextData;
import org.netbeans.modules.web.monitor.data.CookiesData;
import org.netbeans.modules.web.monitor.data.DataRecord;
import org.netbeans.modules.web.monitor.data.Dispatches;
import org.netbeans.modules.web.monitor.data.EngineData;
import org.netbeans.modules.web.monitor.data.RequestData;
import org.netbeans.modules.web.monitor.data.ServletData;
import org.netbeans.modules.web.monitor.data.SessionData;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class MonitorData
extends BaseBean
implements DataRecord {
    private static final boolean debug = false;
    static Vector<BeanComparator> comparators = new Vector();
    public static final String CLIENTDATA = "ClientData";
    public static final String SESSIONDATA = "SessionData";
    public static final String COOKIESDATA = "CookiesData";
    public static final String REQUESTDATA = "RequestData";
    public static final String SERVLETDATA = "ServletData";
    public static final String CONTEXTDATA = "ContextData";
    public static final String ENGINEDATA = "EngineData";
    public static final String MONITORDATA = "MonitorData";
    public static final String DISPATCHES = "Dispatches";

    public MonitorData() {
        this(null, 1);
    }

    public MonitorData(Node doc, int options) {
        this(2);
        if (doc == null && (doc = GraphManager.createRootElementNode((String)MONITORDATA)) == null) {
            throw new RuntimeException("failed to create a new DOM root!");
        }
        Node n = GraphManager.getElementNode((String)MONITORDATA, (Node)doc);
        if (n == null) {
            throw new RuntimeException("doc root not found in the DOM graph!");
        }
        this.graphManager.setXmlDocument(doc);
        this.createBean(n, this.graphManager());
        this.initialize(options);
    }

    public MonitorData(int options) {
        super(comparators, new Version(1, 0, 6));
        this.graphManager = new GraphManager((BaseBean)this);
        this.createRoot(MONITORDATA, MONITORDATA, 544, MonitorData.class);
        this.createProperty(CLIENTDATA, CLIENTDATA, 66080, ClientData.class);
        this.createAttribute(CLIENTDATA, "protocol", "Protocol", 257, null, null);
        this.createAttribute(CLIENTDATA, "remoteAddress", "RemoteAddress", 257, null, null);
        this.createAttribute(CLIENTDATA, "software", "Software", 513, null, null);
        this.createAttribute(CLIENTDATA, "locale", "Locale", 513, null, null);
        this.createAttribute(CLIENTDATA, "formatsAccepted", "FormatsAccepted", 513, null, null);
        this.createAttribute(CLIENTDATA, "encodingsAccepted", "EncodingsAccepted", 513, null, null);
        this.createAttribute(CLIENTDATA, "charsetsAccepted", "CharsetsAccepted", 513, null, null);
        this.createProperty(SESSIONDATA, SESSIONDATA, 66064, SessionData.class);
        this.createAttribute(SESSIONDATA, "before", "Before", 258, new String[]{"false", "true"}, "false");
        this.createAttribute(SESSIONDATA, "after", "After", 258, new String[]{"false", "true"}, "false");
        this.createAttribute(SESSIONDATA, "id", "Id", 513, null, null);
        this.createAttribute(SESSIONDATA, "created", "Created", 513, null, null);
        this.createProperty(COOKIESDATA, COOKIESDATA, 66064, CookiesData.class);
        this.createProperty(REQUESTDATA, REQUESTDATA, 66080, RequestData.class);
        this.createAttribute(REQUESTDATA, "uri", "Uri", 257, null, null);
        this.createAttribute(REQUESTDATA, "method", "Method", 257, null, null);
        this.createAttribute(REQUESTDATA, "urlencoded", "Urlencoded", 513, null, null);
        this.createAttribute(REQUESTDATA, "queryString", "QueryString", 513, null, null);
        this.createAttribute(REQUESTDATA, "replace", "Replace", 513, null, null);
        this.createAttribute(REQUESTDATA, "protocol", "Protocol", 513, null, null);
        this.createAttribute(REQUESTDATA, "ipaddress", "Ipaddress", 513, null, null);
        this.createAttribute(REQUESTDATA, "scheme", "Scheme", 513, null, null);
        this.createAttribute(REQUESTDATA, "status", "Status", 513, null, null);
        this.createProperty(SERVLETDATA, SERVLETDATA, 66064, ServletData.class);
        this.createAttribute(SERVLETDATA, "name", "Name", 513, null, null);
        this.createAttribute(SERVLETDATA, "className", "ClassName", 513, null, null);
        this.createAttribute(SERVLETDATA, "packageName", "PackageName", 513, null, null);
        this.createAttribute(SERVLETDATA, "servletInfo", "ServletInfo", 513, null, null);
        this.createAttribute(SERVLETDATA, "relPath", "RelPath", 513, null, null);
        this.createAttribute(SERVLETDATA, "transPath", "TransPath", 513, null, null);
        this.createAttribute(SERVLETDATA, "contextName", "ContextName", 513, null, null);
        this.createAttribute(SERVLETDATA, "absPath", "AbsPath", 513, null, null);
        this.createAttribute(SERVLETDATA, "jre", "Jre", 513, null, null);
        this.createAttribute(SERVLETDATA, "platform", "Platform", 513, null, null);
        this.createAttribute(SERVLETDATA, "serverPort", "ServerPort", 515, null, null);
        this.createAttribute(SERVLETDATA, "serverName", "ServerName", 513, null, null);
        this.createAttribute(SERVLETDATA, "collected", "Collected", 513, null, null);
        this.createProperty(CONTEXTDATA, CONTEXTDATA, 66064, ContextData.class);
        this.createAttribute(CONTEXTDATA, "contextName", "ContextName", 513, null, null);
        this.createAttribute(CONTEXTDATA, "absPath", "AbsPath", 513, null, null);
        this.createProperty(ENGINEDATA, ENGINEDATA, 66064, EngineData.class);
        this.createAttribute(ENGINEDATA, "jre", "Jre", 513, null, null);
        this.createAttribute(ENGINEDATA, "platform", "Platform", 513, null, null);
        this.createAttribute(ENGINEDATA, "serverPort", "ServerPort", 515, null, null);
        this.createAttribute(ENGINEDATA, "serverName", "ServerName", 513, null, null);
        this.createAttribute("resource", "Resource", 257, null, null);
        this.createAttribute("timestamp", "Timestamp", 257, null, null);
        this.createAttribute("id", "Id", 257, null, null);
        this.createAttribute("method", "Metod", 257, null, null);
        this.createProperty(DISPATCHES, DISPATCHES, 66064, Dispatches.class);
        this.initialize(options);
    }

    void initialize(int options) {
    }

    @Override
    public void setClientData(ClientData value) {
        this.setValue(CLIENTDATA, (Object)value);
    }

    @Override
    public ClientData getClientData() {
        return (ClientData)((Object)this.getValue(CLIENTDATA));
    }

    @Override
    public void setSessionData(SessionData value) {
        this.setValue(SESSIONDATA, (Object)value);
    }

    @Override
    public SessionData getSessionData() {
        return (SessionData)((Object)this.getValue(SESSIONDATA));
    }

    @Override
    public void setCookiesData(CookiesData value) {
        this.setValue(COOKIESDATA, (Object)value);
    }

    @Override
    public CookiesData getCookiesData() {
        return (CookiesData)((Object)this.getValue(COOKIESDATA));
    }

    @Override
    public void setDispatches(Dispatches value) {
        this.setValue(DISPATCHES, (Object)value);
    }

    @Override
    public Dispatches getDispatches() {
        return (Dispatches)((Object)this.getValue(DISPATCHES));
    }

    @Override
    public void setRequestData(RequestData value) {
        this.setValue(REQUESTDATA, (Object)value);
    }

    @Override
    public RequestData getRequestData() {
        return (RequestData)((Object)this.getValue(REQUESTDATA));
    }

    @Override
    public void setServletData(ServletData value) {
        this.setValue(SERVLETDATA, (Object)value);
    }

    @Override
    public ServletData getServletData() {
        return (ServletData)((Object)this.getValue(SERVLETDATA));
    }

    @Override
    public void setEngineData(EngineData value) {
        this.setValue(ENGINEDATA, (Object)value);
    }

    @Override
    public EngineData getEngineData() {
        return (EngineData)((Object)this.getValue(ENGINEDATA));
    }

    @Override
    public void setContextData(ContextData value) {
        this.setValue(CONTEXTDATA, (Object)value);
    }

    @Override
    public ContextData getContextData() {
        return (ContextData)((Object)this.getValue(CONTEXTDATA));
    }

    public boolean verify() {
        return true;
    }

    public String getServerAndPort() {
        String server = null;
        String port = null;
        try {
            server = this.getEngineData().getAttributeValue("serverName");
            port = this.getEngineData().getAttributeValue("serverPort");
            return server.concat(":").concat(port);
        }
        catch (NullPointerException nullPointerException) {
            server = this.getServletData().getAttributeValue("serverName");
            port = this.getServletData().getAttributeValue("serverPort");
            return server.concat(":").concat(port);
        }
    }

    public String getServerName() {
        try {
            return this.getEngineData().getAttributeValue("serverName");
        }
        catch (NullPointerException nullPointerException) {
            return this.getServletData().getAttributeValue("serverName");
        }
    }

    public int getServerPort() {
        String portS = null;
        try {
            portS = this.getEngineData().getAttributeValue("serverPort");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (portS == null) {
            portS = this.getServletData().getAttributeValue("serverPort");
        }
        return Integer.parseInt(portS);
    }

    public String getServerPortAsString() {
        String portS = null;
        try {
            portS = this.getEngineData().getAttributeValue("serverPort");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (portS == null) {
            portS = this.getServletData().getAttributeValue("serverPort");
        }
        return portS;
    }

    public void setServerName(String server) {
        try {
            this.getEngineData().setAttributeValue("serverName", server);
            return;
        }
        catch (NullPointerException nullPointerException) {
            try {
                this.getServletData().getAttributeValue("serverName, server");
                return;
            }
            catch (NullPointerException nullPointerException2) {
                return;
            }
        }
    }

    public void setServerPort(int port) {
        try {
            this.getEngineData().setAttributeValue("serverPort", String.valueOf(port));
            return;
        }
        catch (NullPointerException nullPointerException) {
            try {
                this.getServletData().setAttributeValue("serverPort", String.valueOf(port));
                return;
            }
            catch (NullPointerException nullPointerException2) {
                return;
            }
        }
    }

    public void setServerPort(String port) {
        try {
            this.getEngineData().setAttributeValue("serverPort", port);
            return;
        }
        catch (NullPointerException nullPointerException) {
            try {
                this.getServletData().setAttributeValue("serverPort", port);
                return;
            }
            catch (NullPointerException nullPointerException2) {
                return;
            }
        }
    }

    public static void addComparator(BeanComparator c) {
        comparators.add(c);
    }

    public static void removeComparator(BeanComparator c) {
        comparators.remove(c);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        BeanProp p = this.beanProp();
        if (p != null) {
            p.addPCListener(l);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        BeanProp p = this.beanProp();
        if (p != null) {
            p.removePCListener(l);
        }
    }

    public void addPropertyChangeListener(String n, PropertyChangeListener l) {
        BeanProp p = this.beanProp(n);
        if (p != null) {
            p.addPCListener(l);
        }
    }

    public void removePropertyChangeListener(String n, PropertyChangeListener l) {
        BeanProp p = this.beanProp(n);
        if (p != null) {
            p.removePCListener(l);
        }
    }

    public static MonitorData createGraph(Node doc) {
        return new MonitorData(doc, 2);
    }

    public static MonitorData createGraph(Reader reader) throws IOException {
        return MonitorData.createGraph(reader, false);
    }

    public static MonitorData createGraph(Reader reader, boolean validate) throws IOException {
        try {
            InputSource insource = new InputSource(reader);
            insource.setEncoding("UTF-8");
            Document doc = GraphManager.createXmlDocument((InputSource)insource, (boolean)validate);
            return MonitorData.createGraph(doc);
        }
        catch (Throwable t) {
            throw new IOException();
        }
    }

    public static MonitorData createGraph() {
        return new MonitorData();
    }

    public void write(OutputStream out) throws IOException {
        throw new RuntimeException("Don't do this!");
    }

    public void write(Writer writer) throws IOException {
        try {
            this.write(writer, "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public void dump(StringBuffer str, String indent) {
        str.append(indent);
        str.append(CLIENTDATA);
        BaseBean n = this.getClientData();
        if (n != null) {
            n.dump(str, indent + "\t");
        } else {
            str.append(indent + "\tnull");
        }
        this.dumpAttributes(CLIENTDATA, 0, str, indent);
        str.append(indent);
        str.append(SESSIONDATA);
        n = this.getSessionData();
        if (n != null) {
            n.dump(str, indent + "\t");
        } else {
            str.append(indent + "\tnull");
        }
        this.dumpAttributes(SESSIONDATA, 0, str, indent);
        str.append(indent);
        str.append(COOKIESDATA);
        n = this.getCookiesData();
        if (n != null) {
            n.dump(str, indent + "\t");
        } else {
            str.append(indent + "\tnull");
        }
        this.dumpAttributes(COOKIESDATA, 0, str, indent);
        str.append(indent);
        str.append(REQUESTDATA);
        n = this.getRequestData();
        if (n != null) {
            n.dump(str, indent + "\t");
        } else {
            str.append(indent + "\tnull");
        }
        this.dumpAttributes(REQUESTDATA, 0, str, indent);
        str.append(indent);
        str.append(SERVLETDATA);
        n = this.getServletData();
        if (n != null) {
            n.dump(str, indent + "\t");
        } else {
            str.append(indent + "\tnull");
        }
        this.dumpAttributes(SERVLETDATA, 0, str, indent);
        str.append(CONTEXTDATA);
        n = this.getContextData();
        if (n != null) {
            n.dump(str, indent + "\t");
        } else {
            str.append(indent + "\tnull");
        }
        this.dumpAttributes(CONTEXTDATA, 0, str, indent);
        str.append(indent);
        str.append(DISPATCHES);
        n = this.getDispatches();
        if (n != null) {
            n.dump(str, indent + "\t");
        } else {
            str.append(indent + "\tnull");
        }
        this.dumpAttributes(DISPATCHES, 0, str, indent);
    }

    public String dumpBeanNode() {
        StringBuffer str = new StringBuffer();
        str.append("MonitorData\n");
        this.dump(str, "\n  ");
        return str.toString();
    }

    public String createTempFile(String filename) {
        StringBuffer buf = new StringBuffer(System.getProperty("java.io.tmpdir"));
        buf.append(System.getProperty("file.separator"));
        buf.append(filename);
        try {
            File file = new File(buf.toString());
            FileOutputStream fout = new FileOutputStream(file);
            PrintWriter pw = new PrintWriter(fout);
            this.write(pw);
            pw.close();
            fout.close();
            return file.getAbsolutePath();
        }
        catch (Throwable throwable) {
            return "null";
        }
    }
}

