/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javawebstart;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.SignJar;
import org.apache.tools.ant.types.FileSet;

public class SignJarsTask
extends Task {
    private static final String SIG_START = "META-INF/";
    private static final String SIG_END = ".SF";
    private int compIndex = 1;
    private String keystore;
    private String storepass;
    private String keypass;
    private String alias;
    private File mainJar;
    private File destDir;
    private String codebase;
    private String compProp;
    private String signedJarsProp;
    private List<FileSet> filesets = new LinkedList<FileSet>();

    public void setKeystore(String string) {
        this.keystore = string;
    }

    public void setStorepass(String string) {
        this.storepass = string;
    }

    public void setKeypass(String string) {
        this.keypass = string;
    }

    public void setAlias(String string) {
        this.alias = string;
    }

    public void setMainjar(File file) {
        this.mainJar = file;
    }

    public void setDestdir(File file) {
        this.destDir = file;
    }

    public void setCodebase(String string) {
        this.codebase = string;
    }

    public void setComponentsprop(String string) {
        this.compProp = string;
    }

    public void setSignedjarsprop(String string) {
        this.signedJarsProp = string;
    }

    public void addFileset(FileSet fileSet) {
        this.filesets.add(fileSet);
    }

    public void execute() throws BuildException {
        Object object;
        File file;
        HashMap hashMap = new HashMap();
        ArrayList<File> arrayList = new ArrayList<File>();
        ArrayList<File> arrayList2 = new ArrayList<File>();
        for (FileSet object22 : this.filesets) {
            String[] stringArray;
            file = object22.getDir(this.getProject());
            if (!file.exists()) continue;
            this.log("Processing FileSet: " + object22, 3);
            object = object22.getDirectoryScanner(this.getProject());
            File file2 = object.getBasedir();
            for (String string : stringArray = object.getIncludedFiles()) {
                try {
                    File file3 = new File(file2, string);
                    Set<String> set = SignJarsTask.getSignatures(file3);
                    if (set.size() == 0) {
                        arrayList.add(file3);
                        continue;
                    }
                    if (set.size() == 1 && set.contains(this.alias.toUpperCase())) {
                        arrayList2.add(file3);
                        continue;
                    }
                    List list = (List)hashMap.get(set);
                    if (list != null) {
                        list.add(file3);
                        continue;
                    }
                    ArrayList<File> arrayList3 = new ArrayList<File>();
                    arrayList3.add(file3);
                    hashMap.put(set, arrayList3);
                }
                catch (IOException iOException) {
                    throw new BuildException((Throwable)iOException, this.getLocation());
                }
            }
        }
        this.log("Files to be signed: " + this.mainJar.toString() + ", " + ((Object)arrayList).toString(), 3);
        this.log("Files already signed by requested alias: " + ((Object)arrayList2).toString(), 3);
        StringBuilder stringBuilder = new StringBuilder();
        file = (SignJar)this.getProject().createTask("signjar");
        file.setLocation(this.getLocation());
        file.setKeystore(this.keystore);
        file.setStorepass(this.storepass);
        file.setKeypass(this.keypass);
        file.setAlias(this.alias);
        file.init();
        this.log("Signing main jar file: " + this.mainJar, 3);
        file.setJar(this.mainJar);
        file.execute();
        if (arrayList.size() > 0) {
            for (File file4 : arrayList) {
                this.log("Signing file: " + file4, 3);
                file.setJar(file4);
                file.execute();
                stringBuilder.append("\n        <jar href=\"lib/" + file4.getName() + "\" download=\"eager\"/>");
            }
        }
        if (arrayList2.size() > 0) {
            for (File file5 : arrayList2) {
                this.log("Adding signed file: " + file5, 3);
                stringBuilder.append("\n        <jar href=\"lib/" + file5.getName() + "\" download=\"eager\"/>");
            }
        }
        this.getProject().setProperty(this.signedJarsProp, stringBuilder.toString());
        object = new StringBuilder();
        for (Map.Entry entry : hashMap.entrySet()) {
            this.log("Already signed: keystore aliases = " + entry.getKey() + " -> signed jars = " + entry.getValue(), 3);
            String string = "jnlpcomponent" + this.compIndex++;
            this.createJNLPComponentFile((Set)entry.getKey(), (List)entry.getValue(), string);
            ((StringBuilder)object).append("\n        <extension name=\"" + string + "\" href=\"" + string + ".jnlp\"/>");
        }
        this.getProject().setProperty(this.compProp, ((StringBuilder)object).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<String> getSignatures(File file) throws IOException {
        HashSet<String> hashSet = new HashSet<String>(3);
        try (ZipFile zipFile = null;){
            zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                if (zipEntry.isDirectory() || !zipEntry.getName().startsWith(SIG_START) || !zipEntry.getName().endsWith(SIG_END)) continue;
                String string = zipEntry.getName().substring(SIG_START.length(), zipEntry.getName().indexOf(SIG_END));
                hashSet.add(string);
            }
        }
        return hashSet;
    }

    private String createJNLPComponentFile(Set<String> set, List<File> list, String string) {
        File file = new File(this.destDir, string + ".jnlp");
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(file);
        }
        catch (IOException iOException) {
            throw new BuildException((Throwable)iOException, this.getLocation());
        }
        printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        printWriter.println("<jnlp spec=\"1.0+\" codebase=\"" + this.codebase + "\">");
        printWriter.println("    <information>");
        printWriter.println("        <title>" + string + "</title>");
        printWriter.println("        <vendor>" + this.concatSet(set) + "</vendor>");
        printWriter.println("    </information>");
        printWriter.println("    <security>");
        printWriter.println("        <all-permissions/>");
        printWriter.println("    </security>");
        printWriter.println("    <resources>");
        Iterator<File> iterator = list.iterator();
        while (iterator.hasNext()) {
            printWriter.println("        <jar href=\"" + this.getPath(this.destDir.getAbsolutePath(), iterator.next().getAbsolutePath()) + "\" download=\"eager\"/>");
        }
        printWriter.println("    </resources>");
        printWriter.println("    <component-desc/>");
        printWriter.println("</jnlp>");
        printWriter.flush();
        printWriter.close();
        return file.getAbsolutePath();
    }

    private String getPath(String string, String string2) {
        String string3 = null;
        if (string2.indexOf(string) != -1) {
            string3 = string2.substring(string.length() + 1).replace('\\', '/');
        }
        return string3;
    }

    private String concatSet(Set<String> set) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        Iterator<String> iterator = set.iterator();
        while (iterator.hasNext()) {
            if (bl) {
                stringBuilder.append((Object)iterator.next());
                continue;
            }
            stringBuilder.append(", " + iterator.next());
        }
        return stringBuilder.toString();
    }
}

