/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.actions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.gradle.actions.ActionPersistenceUtils;
import org.netbeans.modules.gradle.actions.ActionToTaskUtils;
import org.netbeans.modules.gradle.actions.Bundle;
import org.netbeans.modules.gradle.actions.DefaultActionMapping;
import org.netbeans.modules.gradle.api.execute.ActionMapping;
import org.netbeans.modules.gradle.api.execute.GradleExecConfiguration;
import org.netbeans.modules.gradle.customizer.CustomActionMapping;
import org.netbeans.modules.gradle.execute.ConfigurableActionProvider;
import org.netbeans.modules.gradle.spi.actions.ProjectActionMappingProvider;
import org.openide.awt.NotificationDisplayer;

public class CustomActionRegistrationSupport {
    public static final String ACTION_PROP_PREFIX = "action.";
    final Project project;
    final Map<String, ActionsHolder> configHolders = new HashMap<String, ActionsHolder>();
    GradleExecConfiguration config;
    Map<String, CustomActionMapping> customActions = new TreeMap<String, CustomActionMapping>();

    public CustomActionRegistrationSupport(Project project) {
        this.project = project;
        this.config = ActionToTaskUtils.findProjectConfiguration(project);
        this.loadCustomizedActions(this.config);
    }

    private void loadCustomizedActions(GradleExecConfiguration c) {
        String id = c != null ? c.getId() : "%%DEFAULT%%";
        ActionsHolder h = this.configHolders.get(id);
        if (h != null) {
            this.customActions = h.customActions;
            return;
        }
        ActionsHolder nh = new ActionsHolder(c);
        ConfigurableActionProvider configP = (ConfigurableActionProvider)this.project.getLookup().lookup(ConfigurableActionProvider.class);
        ProjectActionMappingProvider actionP = null;
        if (configP != null) {
            actionP = configP.findActionProvider(id);
        }
        if (actionP == null) {
            actionP = (ProjectActionMappingProvider)this.project.getLookup().lookup(ProjectActionMappingProvider.class);
        }
        if (actionP != null) {
            ProjectActionMappingProvider fa = actionP;
            Set<String> customizedActions = actionP.customizedActions();
            customizedActions.forEach(action -> {
                ActionMapping ca = fa.findMapping((String)action);
                if (ca == null) {
                    ca = DefaultActionMapping.DISABLED;
                }
                CustomActionMapping mapping = new CustomActionMapping(ca, (String)action);
                nh.customActions.put((String)action, mapping);
            });
        }
        this.configHolders.put(id, nh);
        this.customActions = nh.customActions;
    }

    public void setActiveConfiguration(GradleExecConfiguration cfg) {
        if (cfg == null) {
            cfg = ActionToTaskUtils.findProjectConfiguration(this.project);
        }
        if (Objects.equals(this.config, cfg)) {
            return;
        }
        this.config = cfg;
        this.loadCustomizedActions(cfg);
    }

    public String findNewCustonActionId() {
        String ret;
        int i = 1;
        while (this.customActions.containsKey(ret = "custom-" + i++)) {
        }
        return ret;
    }

    public CustomActionMapping registerCustomAction(String name, String displayName, String args, ActionMapping.ReloadRule rule, boolean repeatable) {
        CustomActionMapping mapping = new CustomActionMapping(name);
        mapping.setDisplayName(displayName);
        mapping.setArgs(args);
        mapping.setReloadRule(rule);
        mapping.setRepeatable(repeatable);
        return this.registerCustomAction(mapping);
    }

    public CustomActionMapping registerCustomAction(CustomActionMapping mapping) {
        this.customActions.put(mapping.getName(), mapping);
        return mapping;
    }

    public CustomActionMapping registerCustomAction(String displayName, String args) {
        String name = this.getByDisplayName(displayName);
        if (name == null) {
            name = this.findNewCustonActionId();
        }
        return this.registerCustomAction(name, displayName, args, ActionMapping.ReloadRule.DEFAULT, true);
    }

    public CustomActionMapping unregisterCustomAction(String name) {
        return this.customActions.remove(name);
    }

    public CustomActionMapping getCustomAction(String name) {
        return this.customActions.get(name);
    }

    public Collection<CustomActionMapping> getCustomActions() {
        return Collections.unmodifiableCollection(this.customActions.values());
    }

    private String getByDisplayName(String displayName) {
        String ret = null;
        for (CustomActionMapping value : this.customActions.values()) {
            if (!value.getDisplayName().equals(displayName)) continue;
            ret = value.getName();
            break;
        }
        return ret;
    }

    public void saveAndReportErrors() {
        try {
            this.save();
        }
        catch (IOException ex) {
            NotificationDisplayer.getDefault().notify(Bundle.ERR_ErrorSavingActions(), null, Bundle.ERR_ErrorSavingActionsDetails(ex.getLocalizedMessage()), null, NotificationDisplayer.Priority.HIGH);
        }
    }

    public void save() throws IOException {
        IOException[] thrown = new IOException[1];
        ProjectManager.mutex().writeAccess(() -> {
            try {
                this.project.getProjectDirectory().getFileSystem().runAtomicAction(() -> {
                    for (Map.Entry<String, ActionsHolder> entry : this.configHolders.entrySet()) {
                        String s = entry.getKey();
                        ActionsHolder h = entry.getValue();
                        ArrayList<ActionMapping> actions = new ArrayList<ActionMapping>(h.customActions.values());
                        actions.sort(Comparable::compareTo);
                        try {
                            ActionPersistenceUtils.writeActions(this.project.getProjectDirectory(), s, actions);
                        }
                        catch (IOException ex) {
                            if (thrown[0] == null) {
                                thrown[0] = ex;
                                continue;
                            }
                            thrown[0].addSuppressed(ex);
                        }
                    }
                });
            }
            catch (IOException ex) {
                thrown[0] = ex;
            }
        });
        if (thrown[0] != null) {
            throw thrown[0];
        }
    }

    class ActionsHolder {
        final GradleExecConfiguration config;
        final String id;
        Map<String, CustomActionMapping> customActions = new TreeMap<String, CustomActionMapping>();

        public ActionsHolder(GradleExecConfiguration config) {
            this.config = config;
            this.id = config == null ? "%%DEFAULT%%" : config.getId();
        }
    }
}

