/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.common.ProjectUtil;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.javaee.specs.support.api.JaxRpc;
import org.netbeans.modules.javaee.specs.support.api.JaxRpcStackSupport;
import org.netbeans.modules.javaee.specs.support.api.JaxWs;
import org.netbeans.modules.javaee.specs.support.api.JaxWsStackSupport;
import org.netbeans.modules.websvc.api.webservices.WebServicesSupport;
import org.netbeans.modules.websvc.core.ServerType;
import org.netbeans.modules.websvc.wsstack.api.WSStack;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class WSStackUtils {
    Project project;
    J2eePlatform j2eePlatform;

    public WSStackUtils(Project project) {
        this.project = project;
        this.j2eePlatform = this.getJ2eePlatform(project);
    }

    private J2eePlatform getJ2eePlatform(Project project) {
        String serverInstanceID;
        J2eeModuleProvider provider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (provider != null && (serverInstanceID = provider.getServerInstanceID()) != null && serverInstanceID.length() > 0) {
            try {
                return Deployment.getDefault().getServerInstance(serverInstanceID).getJ2eePlatform();
            }
            catch (InstanceRemovedException ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Failed to find J2eePlatform");
            }
        }
        return null;
    }

    public boolean isWsitSupported() {
        if (this.j2eePlatform != null) {
            WSStack wsStack = JaxWsStackSupport.getJaxWsStack((J2eePlatform)this.j2eePlatform);
            return wsStack != null && wsStack.isFeatureSupported((WSStack.Feature)JaxWs.Feature.WSIT);
        }
        return false;
    }

    public boolean isJsr109Supported() {
        if (this.j2eePlatform != null) {
            WSStack wsStack = JaxWsStackSupport.getJaxWsStack((J2eePlatform)this.j2eePlatform);
            return wsStack != null && wsStack.isFeatureSupported((WSStack.Feature)JaxWs.Feature.JSR109);
        }
        return false;
    }

    public boolean isJsr109OldSupported() {
        if (this.j2eePlatform != null) {
            WSStack wsStack = JaxRpcStackSupport.getJaxWsStack((J2eePlatform)this.j2eePlatform);
            return wsStack != null && wsStack.isFeatureSupported((WSStack.Feature)JaxRpc.Feature.JSR109);
        }
        return false;
    }

    public boolean hasJAXWSLibrary() {
        SourceGroup[] sgs = ProjectUtils.getSources((Project)this.project).getSourceGroups("java");
        ClassPath classPath = ClassPath.getClassPath((FileObject)sgs[0].getRootFolder(), (String)"classpath/compile");
        if (classPath == null) {
            return false;
        }
        FileObject wsimportFO = classPath.findResource("com/sun/tools/ws/ant/WsImport.class");
        return wsimportFO != null;
    }

    public static ServerType getServerType(Project project) {
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (j2eeModuleProvider == null || j2eeModuleProvider.getServerInstanceID() == null) {
            return ServerType.NOT_SPECIFIED;
        }
        String serverId = j2eeModuleProvider.getServerID();
        if (serverId != null) {
            if (serverId.startsWith("Tomcat")) {
                return ServerType.TOMCAT;
            }
            if (serverId.equals("J2EE")) {
                return ServerType.GLASSFISH;
            }
            if (serverId.startsWith("gfv3")) {
                return ServerType.GLASSFISH_V3;
            }
            if (serverId.equals("GlassFish")) {
                return ServerType.GLASSFISH;
            }
            if (serverId.equals("APPSERVER")) {
                return ServerType.GLASSFISH;
            }
            if (serverId.equals("JavaEE")) {
                return ServerType.GLASSFISH;
            }
            if (serverId.startsWith("JBoss")) {
                return ServerType.JBOSS;
            }
            if (serverId.startsWith("WebLogic")) {
                return ServerType.WEBLOGIC;
            }
            if (serverId.startsWith("WebSphere")) {
                return ServerType.WEBSPHERE;
            }
            return ServerType.UNKNOWN;
        }
        return ServerType.NOT_SPECIFIED;
    }

    public ServerType getServerType() {
        return WSStackUtils.getServerType(this.project);
    }

    public <T> WSStack<T> getWsStack(Class<T> stackDescriptor) {
        if (this.j2eePlatform != null) {
            return WSStack.findWSStack((Lookup)this.j2eePlatform.getLookup(), stackDescriptor);
        }
        return null;
    }

    boolean isWebModule() {
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        if (j2eeModuleProvider != null) {
            return J2eeModule.Type.WAR.equals(j2eeModuleProvider.getJ2eeModule().getType());
        }
        return false;
    }

    public ErrorMessage getErrorMessage(WizardType wizardType) {
        switch (wizardType) {
            case WS: {
                return this.getWSErrorMessage();
            }
            case WS_FROM_WSDL: {
                return this.getWSErrorMessage();
            }
            case WS_CLIENT: {
                break;
            }
        }
        return null;
    }

    private ErrorMessage getWSErrorMessage() {
        ServerType serverType = this.getServerType();
        if (ProjectUtil.isJavaEE5orHigher((Project)this.project)) {
            if (ServerType.GLASSFISH_V3 == serverType && !this.isWsitSupported()) {
                return new ErrorMessage(ErrorType.INFO, NbBundle.getMessage(WSStackUtils.class, (String)"MSG_NoMetroInstalled"), false);
            }
        } else {
            boolean jBoss;
            boolean noJsr109InWeb = this.isWebModule() && !this.isJsr109Supported() && !this.isJsr109OldSupported();
            boolean bl = jBoss = ServerType.JBOSS == this.getServerType();
            if (!noJsr109InWeb && !jBoss && WebServicesSupport.getWebServicesSupport((FileObject)this.project.getProjectDirectory()) == null) {
                return new ErrorMessage(ErrorType.ERROR, NbBundle.getMessage(WSStackUtils.class, (String)"MSG_NoJaxrpcPluginFound"));
            }
        }
        return null;
    }

    public static enum WizardType {
        WS,
        WS_FROM_WSDL,
        WS_CLIENT;

    }

    public static class ErrorMessage {
        private ErrorType type;
        private String text;
        private boolean serious;

        public ErrorMessage(ErrorType type, String text) {
            this(type, text, true);
        }

        public ErrorMessage(ErrorType type, String text, boolean serious) {
            this.type = type;
            this.text = text;
            this.serious = serious;
        }

        public String getText() {
            return this.text;
        }

        public ErrorType getType() {
            return this.type;
        }

        public String getWizardMessageProperty() {
            switch (this.type) {
                case ERROR: {
                    return "WizardPanel_errorMessage";
                }
                case INFO: {
                    return "WizardPanel_infoMessage";
                }
                case WARNING: {
                    return "WizardPanel_warningMessage";
                }
            }
            return "WizardPanel_errorMessage";
        }

        public boolean isSerious() {
            return this.serious;
        }
    }

    public static enum ErrorType {
        ERROR,
        INFO,
        WARNING;

    }
}

