/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DpdConfig
extends ExplicitlySetBmcModel {
    @JsonProperty(value="dpdMode")
    private final DpdMode dpdMode;
    @JsonProperty(value="dpdTimeoutInSec")
    private final Integer dpdTimeoutInSec;

    @Deprecated
    @ConstructorProperties(value={"dpdMode", "dpdTimeoutInSec"})
    public DpdConfig(DpdMode dpdMode, Integer dpdTimeoutInSec) {
        this.dpdMode = dpdMode;
        this.dpdTimeoutInSec = dpdTimeoutInSec;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public DpdMode getDpdMode() {
        return this.dpdMode;
    }

    public Integer getDpdTimeoutInSec() {
        return this.dpdTimeoutInSec;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DpdConfig(");
        sb.append("super=").append(super.toString());
        sb.append("dpdMode=").append(String.valueOf((Object)this.dpdMode));
        sb.append(", dpdTimeoutInSec=").append(String.valueOf(this.dpdTimeoutInSec));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DpdConfig)) {
            return false;
        }
        DpdConfig other = (DpdConfig)((Object)o);
        return Objects.equals((Object)this.dpdMode, (Object)other.dpdMode) && Objects.equals(this.dpdTimeoutInSec, other.dpdTimeoutInSec) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.dpdMode == null ? 43 : this.dpdMode.hashCode());
        result = result * 59 + (this.dpdTimeoutInSec == null ? 43 : this.dpdTimeoutInSec.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum DpdMode implements BmcEnum
    {
        InitiateAndRespond("INITIATE_AND_RESPOND"),
        RespondOnly("RESPOND_ONLY");

        private final String value;
        private static Map<String, DpdMode> map;

        private DpdMode(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DpdMode create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid DpdMode: " + key);
        }

        static {
            map = new HashMap<String, DpdMode>();
            for (DpdMode v : DpdMode.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="dpdMode")
        private DpdMode dpdMode;
        @JsonProperty(value="dpdTimeoutInSec")
        private Integer dpdTimeoutInSec;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder dpdMode(DpdMode dpdMode) {
            this.dpdMode = dpdMode;
            this.__explicitlySet__.add("dpdMode");
            return this;
        }

        public Builder dpdTimeoutInSec(Integer dpdTimeoutInSec) {
            this.dpdTimeoutInSec = dpdTimeoutInSec;
            this.__explicitlySet__.add("dpdTimeoutInSec");
            return this;
        }

        public DpdConfig build() {
            DpdConfig model = new DpdConfig(this.dpdMode, this.dpdTimeoutInSec);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DpdConfig model) {
            if (model.wasPropertyExplicitlySet("dpdMode")) {
                this.dpdMode(model.getDpdMode());
            }
            if (model.wasPropertyExplicitlySet("dpdTimeoutInSec")) {
                this.dpdTimeoutInSec(model.getDpdTimeoutInSec());
            }
            return this;
        }
    }
}

