/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.ServiceGateway;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GetServiceGatewayResponse
extends BmcResponse {
    private String etag;
    private String opcRequestId;
    private ServiceGateway serviceGateway;

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public ServiceGateway getServiceGateway() {
        return this.serviceGateway;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "etag", "opcRequestId", "serviceGateway"})
    private GetServiceGatewayResponse(int __httpStatusCode__, Map<String, List<String>> headers, String etag, String opcRequestId, ServiceGateway serviceGateway) {
        super(__httpStatusCode__, headers);
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.serviceGateway = serviceGateway;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",etag=").append(String.valueOf(this.etag));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",serviceGateway=").append(String.valueOf((Object)this.serviceGateway));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetServiceGatewayResponse)) {
            return false;
        }
        GetServiceGatewayResponse other = (GetServiceGatewayResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.etag, other.etag) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.serviceGateway, (Object)other.serviceGateway);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.etag == null ? 43 : this.etag.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.serviceGateway == null ? 43 : this.serviceGateway.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<GetServiceGatewayResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String etag;
        private String opcRequestId;
        private ServiceGateway serviceGateway;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder serviceGateway(ServiceGateway serviceGateway) {
            this.serviceGateway = serviceGateway;
            return this;
        }

        public Builder copy(GetServiceGatewayResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.serviceGateway(o.getServiceGateway());
            return this;
        }

        public GetServiceGatewayResponse build() {
            return new GetServiceGatewayResponse(this.__httpStatusCode__, this.headers, this.etag, this.opcRequestId, this.serviceGateway);
        }
    }
}

