/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.micronaut.completion;

import java.net.URL;
import javax.swing.Action;
import org.netbeans.spi.editor.completion.CompletionDocumentation;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataProperty;
import org.springframework.boot.configurationmetadata.Deprecation;

public class MicronautConfigDocumentation
implements CompletionDocumentation {
    private final ConfigurationMetadataProperty element;

    public MicronautConfigDocumentation(ConfigurationMetadataProperty element) {
        this.element = element;
    }

    public String getText() {
        Deprecation deprecation;
        StringBuilder sb = new StringBuilder();
        sb.append("<b>").append(this.makeNameLineBreakable(this.element.getId())).append("</b>");
        String type = this.element.getType();
        if (type != null) {
            sb.append("<pre>").append(type).append("</pre>");
        }
        String description = this.element.getDescription();
        String params = null;
        if (description != null) {
            int idx = description.indexOf("@param");
            if (idx >= 0) {
                params = description.substring(idx + 6).trim();
                description = description.substring(0, idx).trim();
            }
            if (!description.isEmpty()) {
                sb.append("<p>").append(description).append("</p>");
            }
        }
        if ((deprecation = this.element.getDeprecation()) != null) {
            sb.append("<p><b>Deprecated");
            String reason = deprecation.getReason();
            if (reason != null) {
                sb.append(":</b> <i>").append(reason).append("</i>");
            } else {
                sb.append("</b>");
            }
            String replacement = deprecation.getReplacement();
            if (replacement != null) {
                sb.append("<br/>Replaced by: <code>").append(replacement).append("</code>");
            }
            sb.append("</p>");
        }
        if (params != null) {
            sb.append("<p><b>Parameters:</b><blockquote>");
            int idx = params.indexOf(32);
            if (idx < 0) {
                sb.append(params).append("</p>");
            } else {
                sb.append("<code>").append(params.substring(0, idx)).append("</code>").append(params.substring(idx)).append("</blockquote></p>");
            }
        }
        return sb.toString();
    }

    public URL getURL() {
        return null;
    }

    public CompletionDocumentation resolveLink(String link) {
        return null;
    }

    public Action getGotoSourceAction() {
        return null;
    }

    private String makeNameLineBreakable(String name) {
        return name.replace(".", ".&#x200B;");
    }
}

