/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.nbjavac.services;

import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.api.JavacScope;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Context;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;

public class NBJavacTrees
extends JavacTrees {
    private static final Logger LOG;
    private final Map<Element, TreePath> element2paths = new HashMap<Element, TreePath>();
    private final Check.CheckContext chkBasicHandler;
    private static final Field basicHandlerField;
    private static final Field returnResultField;
    private static final Method dupMethod;

    public static void preRegister(Context context) {
        context.put(JavacTrees.class, new Context.Factory<JavacTrees>(){

            @Override
            public JavacTrees make(Context c) {
                return new NBJavacTrees(c);
            }
        });
    }

    protected NBJavacTrees(Context context) {
        super(context);
        Check chk = Check.instance(context);
        Check.CheckContext chkBasicHandlerTemp = null;
        try {
            if (basicHandlerField != null) {
                chkBasicHandlerTemp = (Check.CheckContext)basicHandlerField.get(chk);
            }
        }
        catch (ReflectiveOperationException ex) {
            LOG.log(Level.FINE, null, ex);
        }
        this.chkBasicHandler = chkBasicHandlerTemp;
    }

    @Override
    public TreePath getPath(Element e) {
        TreePath path = super.getPath(e);
        return path != null ? path : this.element2paths.get(e);
    }

    void addPathForElement(Element elem, TreePath path) {
        this.element2paths.put(elem, path);
    }

    @Override
    public Symbol getElement(TreePath path) {
        return TreeInfo.symbolFor((JCTree)path.getLeaf());
    }

    @Override
    protected JavacTrees.Copier createCopier(TreeMaker maker) {
        return new JavacTrees.Copier(maker){

            @Override
            public JCTree visitVariable(VariableTree node, JCTree p) {
                JCTree.JCVariableDecl old = (JCTree.JCVariableDecl)node;
                JCTree.JCVariableDecl nue = (JCTree.JCVariableDecl)super.visitVariable(node, p);
                if (old.sym != null) {
                    nue.mods.flags |= old.sym.flags_field & 0x20000000000L;
                }
                return nue;
            }
        };
    }

    @Override
    public JavacScope getScope(TreePath path) {
        JavacScope result = super.getScope(path);
        if (returnResultField != null) {
            Env<AttrContext> env = result.getEnv();
            try {
                Object returnResult = returnResultField.get(env.info);
                if (returnResult != null) {
                    returnResultField.set(env.info, dupMethod.invoke(returnResult, this.chkBasicHandler));
                }
            }
            catch (ReflectiveOperationException ex) {
                LOG.log(Level.FINE, null, ex);
            }
        }
        return result;
    }

    static {
        Method dupMethodTemp;
        Field returnResultFieldTemp;
        Field basicHandlerFieldTemp;
        LOG = Logger.getLogger(NBJavacTrees.class.getName());
        try {
            basicHandlerFieldTemp = Check.class.getDeclaredField("basicHandler");
            basicHandlerFieldTemp.setAccessible(true);
            returnResultFieldTemp = AttrContext.class.getDeclaredField("returnResult");
            returnResultFieldTemp.setAccessible(true);
            dupMethodTemp = Class.forName("com.sun.tools.javac.comp.Attr$ResultInfo").getDeclaredMethod("dup", Check.CheckContext.class);
            dupMethodTemp.setAccessible(true);
        }
        catch (ReflectiveOperationException ex) {
            LOG.log(Level.FINE, null, ex);
            basicHandlerFieldTemp = null;
            returnResultFieldTemp = null;
            dupMethodTemp = null;
        }
        basicHandlerField = basicHandlerFieldTemp;
        returnResultField = returnResultFieldTemp;
        dupMethod = dupMethodTemp;
    }
}

