/**
This IndexedDB API interface represents a cursor for traversing or iterating over multiple records in a database. It is the same as the IDBCursor, except that it includes the value property.

@returns {IDBCursorWithValue}
*/
IDBCursorWithValue = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Object}
**/
IDBCursorWithValue.prototype.value = new Object();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {("next" | "nextunique" | "prev" | "prevunique")} IDBCursorDirection
**/
IDBCursorWithValue.prototype.direction = new Object();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Number | String | Date | ArrayBufferView | ArrayBuffer | IDBValidKey[])} IDBValidKey
**/
IDBCursorWithValue.prototype.key = new Object();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Number | String | Date | ArrayBufferView | ArrayBuffer | IDBValidKey[])} IDBValidKey
**/
IDBCursorWithValue.prototype.primaryKey = new Object();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {IDBRequest}
**/
IDBCursorWithValue.prototype.request = new IDBRequest();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(IDBObjectStore | IDBIndex)} IDBObjectStore | IDBIndex
**/
IDBCursorWithValue.prototype.source = new Object();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Advances the cursor through the next count records in range.

@param {Number} count
@returns {undefined}
**/
IDBCursorWithValue.prototype.advance = function(count) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Advances the cursor to the next record in range.

@param {(Number | String | Date | ArrayBufferView | ArrayBuffer | IDBValidKey[])} [key] IDBValidKey
@returns {undefined}
**/
IDBCursorWithValue.prototype.continue = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Advances the cursor to the next record in range matching or after key and primaryKey. Throws an "InvalidAccessError" DOMException if the source is not an index.

@param {(Number | String | Date | ArrayBufferView | ArrayBuffer | IDBValidKey[])} key IDBValidKey
@param {(Number | String | Date | ArrayBufferView | ArrayBuffer | IDBValidKey[])} primaryKey IDBValidKey
@returns {undefined}
**/
IDBCursorWithValue.prototype.continuePrimaryKey = function(key, primaryKey) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Delete the record pointed at by the cursor with a new value.

If successful, request's result will be undefined.

@returns {IDBRequest}
**/
IDBCursorWithValue.prototype.delete = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Updated the record pointed at by the cursor with a new value.

Throws a "DataError" DOMException if the effective object store uses in-line keys and the key would have changed.

If successful, request's result will be the record's key.

@param {Object} value
@returns {IDBRequest}
**/
IDBCursorWithValue.prototype.update = function(value) {};

