/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.jollyday.core;

import de.focus_shift.jollyday.core.HolidayManager;
import de.focus_shift.jollyday.core.ManagerParameter;
import de.focus_shift.jollyday.core.caching.Cache;
import de.focus_shift.jollyday.core.datasource.ConfigurationServiceManager;
import de.focus_shift.jollyday.core.spi.ConfigurationService;
import de.focus_shift.jollyday.core.util.ClassLoadingUtil;

class HolidayManagerValueHandler
implements Cache.ValueHandler<HolidayManager> {
    private final ManagerParameter parameter;
    private final String managerImplClassName;
    private final String configurationServiceImplClassName;
    private final ConfigurationServiceManager configurationServiceManager;

    HolidayManagerValueHandler(ManagerParameter parameter, String managerImplClassName, String configurationServiceImplClassName, ConfigurationServiceManager configurationServiceManager) {
        this.parameter = parameter;
        this.managerImplClassName = managerImplClassName;
        this.configurationServiceImplClassName = configurationServiceImplClassName;
        this.configurationServiceManager = configurationServiceManager;
    }

    @Override
    public String getKey() {
        return this.parameter.createCacheKey();
    }

    @Override
    public HolidayManager createValue() {
        HolidayManager manager = this.instantiateManagerImpl(this.managerImplClassName);
        ConfigurationService configurationService = this.configurationServiceManager.getConfigurationService(this.configurationServiceImplClassName);
        manager.setConfigurationService(configurationService);
        manager.init(this.parameter);
        return manager;
    }

    private HolidayManager instantiateManagerImpl(String managerImplClassName) {
        try {
            Class<?> managerImplClass = ClassLoadingUtil.loadClass(managerImplClassName);
            return (HolidayManager)managerImplClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot create manager class " + managerImplClassName, e);
        }
    }
}

