/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.rules.types;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opensearch.securityanalytics.rules.exceptions.SigmaValueError;
import org.opensearch.securityanalytics.rules.types.Placeholder;
import org.opensearch.securityanalytics.rules.types.SigmaType;
import org.opensearch.securityanalytics.rules.utils.AnyOneOf;
import org.opensearch.securityanalytics.rules.utils.Either;

public class SigmaString
implements SigmaType {
    private String original;
    private List<AnyOneOf<String, Character, Placeholder>> sOpt;

    public SigmaString(String s) {
        if (s == null) {
            s = "";
        }
        this.original = s;
        int sLen = s.length();
        ArrayList<AnyOneOf<String, Character, Placeholder>> r = new ArrayList<AnyOneOf<String, Character, Placeholder>>();
        StringBuilder acc = new StringBuilder();
        boolean escaped = false;
        for (int i = 0; i < sLen; ++i) {
            if (escaped) {
                if (s.charAt(i) == '*' || s.charAt(i) == '?' || s.charAt(i) == '\\') {
                    acc.append(s.charAt(i));
                } else {
                    acc.append('\\').append(s.charAt(i));
                }
                escaped = false;
                continue;
            }
            if (s.charAt(i) == '\\') {
                escaped = true;
                continue;
            }
            if (s.charAt(i) == '*' || s.charAt(i) == '?') {
                if (!acc.toString().equals("")) {
                    r.add(AnyOneOf.leftVal(acc.toString()));
                }
                switch (s.charAt(i)) {
                    case '*': {
                        r.add(AnyOneOf.middleVal(Character.valueOf('*')));
                        break;
                    }
                    case '?': {
                        r.add(AnyOneOf.middleVal(Character.valueOf('?')));
                    }
                }
                acc = new StringBuilder();
                continue;
            }
            acc.append(s.charAt(i));
        }
        if (escaped) {
            acc.append('\\');
        }
        if (!acc.toString().equals("")) {
            r.add(AnyOneOf.leftVal(acc.toString()));
        }
        this.sOpt = r;
    }

    public void mergeStrings() {
        ArrayList<AnyOneOf<String, Character, Placeholder>> mergedOpts = new ArrayList<AnyOneOf<String, Character, Placeholder>>();
        int size = this.sOpt.size();
        for (int i = 0; i < size; ++i) {
            int mSize = mergedOpts.size();
            if (mSize > 0 && ((AnyOneOf)mergedOpts.get(mSize - 1)).isLeft() && this.sOpt.get(i).isLeft()) {
                mergedOpts.set(mSize - 1, AnyOneOf.leftVal((String)((AnyOneOf)mergedOpts.get(mSize - 1)).getLeft() + (String)this.sOpt.get(i).getLeft()));
                continue;
            }
            mergedOpts.add(this.sOpt.get(i));
        }
        this.sOpt = mergedOpts;
    }

    public SigmaString append(AnyOneOf<String, Character, Placeholder> other) {
        this.sOpt.add(other);
        this.mergeStrings();
        return this;
    }

    public SigmaString prepend(AnyOneOf<String, Character, Placeholder> other) {
        this.sOpt.add(0, other);
        this.mergeStrings();
        return this;
    }

    public int length() {
        int sum = 0;
        for (AnyOneOf<String, Character, Placeholder> sOptElem : this.sOpt) {
            if (sOptElem.isLeft()) {
                sum += ((String)sOptElem.getLeft()).length();
                continue;
            }
            ++sum;
        }
        return sum;
    }

    public boolean startsWith(Either<String, Character> val) {
        AnyOneOf<String, Character, Placeholder> c = this.sOpt.get(0);
        if (val.isLeft()) {
            return c.isLeft() && ((String)c.getLeft()).startsWith(val.getLeft());
        }
        if (val.isRight()) {
            return c.isMiddle() && c.getMiddle() == val.get();
        }
        return false;
    }

    public boolean endsWith(Either<String, Character> val) {
        AnyOneOf<String, Character, Placeholder> c = this.sOpt.get(this.sOpt.size() - 1);
        if (val.isLeft()) {
            return c.isLeft() && ((String)c.getLeft()).endsWith(val.getLeft());
        }
        if (val.isRight()) {
            return c.isMiddle() && c.getMiddle() == val.get();
        }
        return false;
    }

    public byte[] getBytes() {
        return this.toString().getBytes(Charset.defaultCharset());
    }

    public boolean containsSpecial() {
        for (AnyOneOf<String, Character, Placeholder> sOptElem : this.sOpt) {
            if (!sOptElem.isMiddle() || sOptElem.getMiddle().charValue() != '\\' && sOptElem.getMiddle().charValue() != '*' && sOptElem.getMiddle().charValue() != '?') continue;
            return true;
        }
        return false;
    }

    public boolean containsWildcard() {
        for (AnyOneOf<String, Character, Placeholder> sOptElem : this.sOpt) {
            if (!sOptElem.isMiddle() || sOptElem.getMiddle().charValue() != '*' && sOptElem.getMiddle().charValue() != '?') continue;
            return true;
        }
        return false;
    }

    public String convert(String escapeChar, String wildcardMulti, String wildcardSingle, String addEscaped, String addReserved, String filterChars) throws SigmaValueError {
        Character c;
        int n;
        int n2;
        Object object;
        StringBuilder s = new StringBuilder();
        HashSet<Character> escapedChars = new HashSet<Character>();
        if (wildcardMulti != null) {
            object = wildcardMulti.toCharArray();
            n2 = ((char[])object).length;
            for (n = 0; n < n2; ++n) {
                c = Character.valueOf((char)object[n]);
                escapedChars.add(c);
            }
        }
        if (wildcardSingle != null) {
            object = wildcardSingle.toCharArray();
            n2 = ((char[])object).length;
            for (n = 0; n < n2; ++n) {
                c = Character.valueOf((char)object[n]);
                escapedChars.add(c);
            }
        }
        if (addEscaped != null) {
            object = addEscaped.toCharArray();
            n2 = ((char[])object).length;
            for (n = 0; n < n2; ++n) {
                c = Character.valueOf((char)object[n]);
                escapedChars.add(c);
            }
        }
        object = this.sOpt.iterator();
        while (object.hasNext()) {
            AnyOneOf sOptElem = (AnyOneOf)object.next();
            if (sOptElem.isLeft()) {
                if (Arrays.stream(addReserved.split(" ")).anyMatch(s1 -> s1.equals(sOptElem.getLeft()))) {
                    s.append(escapeChar);
                    s.append((String)sOptElem.getLeft());
                    continue;
                }
                char[] cArray = ((String)sOptElem.getLeft()).toCharArray();
                int n3 = cArray.length;
                for (int i = 0; i < n3; ++i) {
                    Character c2 = Character.valueOf(cArray[i]);
                    if (filterChars.contains(String.valueOf(c2))) continue;
                    if (escapedChars.contains(c2)) {
                        s.append(escapeChar);
                    }
                    s.append(c2);
                }
                continue;
            }
            if (sOptElem.getMiddle() == null) continue;
            Character c3 = (Character)sOptElem.getMiddle();
            if (c3.charValue() == '*') {
                if (wildcardMulti != null) {
                    s.append(wildcardMulti);
                    continue;
                }
                throw new SigmaValueError("Multi-character wildcard not specified for conversion");
            }
            if (c3.charValue() != '?') continue;
            if (wildcardSingle != null) {
                s.append(wildcardSingle);
                continue;
            }
            throw new SigmaValueError("Single-character wildcard not specified for conversion");
        }
        return s.toString().replace(" ", "_ws_");
    }

    public SigmaString replaceWithPlaceholder(Pattern regex, String placeholderName) {
        ArrayList<AnyOneOf<String, Character, Placeholder>> result = new ArrayList<AnyOneOf<String, Character, Placeholder>>();
        for (AnyOneOf<String, Character, Placeholder> elem : this.sOpt) {
            if (elem.isLeft()) {
                String sElem;
                String elemStr = (String)elem.getLeft();
                boolean matched = false;
                int idx = 0;
                Matcher matcher = regex.matcher(elemStr);
                while (matcher.find()) {
                    matched = true;
                    sElem = elemStr.substring(idx, matcher.start());
                    if (!sElem.isEmpty()) {
                        result.add(AnyOneOf.leftVal(sElem));
                    }
                    result.add(AnyOneOf.rightVal(new Placeholder(placeholderName)));
                    idx = matcher.end();
                }
                if (matched) {
                    sElem = elemStr.substring(idx);
                    if (sElem.isEmpty()) continue;
                    result.add(AnyOneOf.leftVal(sElem));
                    continue;
                }
                result.add(elem);
                continue;
            }
            result.add(elem);
        }
        SigmaString sStr = new SigmaString(null);
        sStr.setsOpt(result);
        return sStr;
    }

    public boolean containsPlaceholder(List<String> include, List<String> exclude) {
        for (AnyOneOf<String, Character, Placeholder> elem : this.sOpt) {
            if (!elem.isRight() || include != null && !include.contains(((Placeholder)elem.get()).getName()) || exclude != null && exclude.contains(((Placeholder)elem.get()).getName())) continue;
            return true;
        }
        return false;
    }

    public List<SigmaString> replacePlaceholders(Function<Placeholder, List<AnyOneOf<String, Character, Placeholder>>> callback) {
        if (!this.containsPlaceholder(null, null)) {
            return List.of(this);
        }
        ArrayList<SigmaString> results = new ArrayList<SigmaString>();
        List<AnyOneOf<String, Character, Placeholder>> s = this.getsOpt();
        int size = s.size();
        for (int idx = 0; idx < size; ++idx) {
            if (!s.get(idx).isRight()) continue;
            SigmaString prefix = new SigmaString(null);
            ArrayList<AnyOneOf<String, Character, Placeholder>> presOpt = new ArrayList<AnyOneOf<String, Character, Placeholder>>();
            for (int preIdx = 0; preIdx < idx; ++preIdx) {
                presOpt.add(s.get(preIdx));
            }
            prefix.setsOpt(presOpt);
            Placeholder placeholder = (Placeholder)s.get(idx).get();
            SigmaString suffix = new SigmaString(null);
            ArrayList<AnyOneOf<String, Character, Placeholder>> sufsOpt = new ArrayList<AnyOneOf<String, Character, Placeholder>>();
            for (int sufIdx = idx + 1; sufIdx < size; ++sufIdx) {
                sufsOpt.add(s.get(sufIdx));
            }
            suffix.setsOpt(sufsOpt);
            for (SigmaString resultSuffix : suffix.replacePlaceholders(callback)) {
                for (AnyOneOf<String, Character, Placeholder> replacement : callback.apply(placeholder)) {
                    SigmaString tempSuffix = new SigmaString(null);
                    tempSuffix.setsOpt(resultSuffix.getsOpt());
                    tempSuffix.prepend(replacement);
                    prefix.getsOpt().forEach(tempSuffix::prepend);
                    results.add(tempSuffix);
                }
            }
            return results;
        }
        return results;
    }

    public List<AnyOneOf<String, Character, Placeholder>> getsOpt() {
        return this.sOpt;
    }

    public void setsOpt(List<AnyOneOf<String, Character, Placeholder>> sOpt) {
        this.sOpt = new ArrayList<AnyOneOf<String, Character, Placeholder>>();
        for (AnyOneOf<String, Character, Placeholder> sOptElem : sOpt) {
            if (sOptElem.isLeft()) {
                this.sOpt.add(AnyOneOf.leftVal((String)sOptElem.getLeft()));
                continue;
            }
            if (sOptElem.isMiddle()) {
                this.sOpt.add(AnyOneOf.middleVal(sOptElem.getMiddle()));
                continue;
            }
            this.sOpt.add(AnyOneOf.rightVal((Placeholder)sOptElem.get()));
        }
    }

    public String getOriginal() {
        return this.original;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SigmaString that = (SigmaString)o;
        if (this.sOpt.size() != that.sOpt.size()) {
            return false;
        }
        for (int idx = 0; idx < this.sOpt.size(); ++idx) {
            if (!(this.sOpt.get(idx).isLeft() && !that.sOpt.get(idx).isLeft() || this.sOpt.get(idx).isMiddle() && !that.sOpt.get(idx).isMiddle()) && (!this.sOpt.get(idx).isRight() || that.sOpt.get(idx).isRight())) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (AnyOneOf<String, Character, Placeholder> sOptElem : this.sOpt) {
            if (sOptElem.isLeft()) {
                sb.append((String)sOptElem.getLeft());
                continue;
            }
            if (!sOptElem.isMiddle()) continue;
            sb.append(sOptElem.getMiddle());
        }
        return sb.toString().replace(" ", "_ws_");
    }

    public class SpecialChars {
        public static final char WILDCARD_MULTI = '*';
        public static final char WILDCARD_SINGLE = '?';
        public static final char ESCAPE_CHAR = '\\';

        public SpecialChars(SigmaString this$0) {
        }
    }
}

