/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.rest;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.searchrelevance.settings.SearchRelevanceSettingsAccessor;
import org.opensearch.searchrelevance.transport.scheduledJob.PostScheduledExperimentAction;
import org.opensearch.searchrelevance.transport.scheduledJob.PostScheduledExperimentRequest;
import org.opensearch.searchrelevance.utils.CronUtil;
import org.opensearch.transport.client.node.NodeClient;

@ExperimentalApi
public class RestPostScheduledExperimentAction
extends BaseRestHandler {
    @Generated
    private static final Logger log = LogManager.getLogger(RestPostScheduledExperimentAction.class);
    private static final String POST_SCHEDULED_EXPERIMENT_ACTION = "post_scheduled_experiment_action";
    private SearchRelevanceSettingsAccessor settingsAccessor;
    private CronUtil cronUtil;

    public String getName() {
        return POST_SCHEDULED_EXPERIMENT_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.POST, "/_plugins/_search_relevance/experiments/schedule"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (!this.settingsAccessor.isWorkbenchEnabled()) {
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.FORBIDDEN, "Search Relevance Workbench is disabled"));
        }
        if (!this.settingsAccessor.isScheduledExperimentsEnabled()) {
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.FORBIDDEN, "Scheduled experiments is disabled"));
        }
        XContentParser parser = request.contentParser();
        Map source = parser.map();
        String experimentId = (String)source.get("experimentId");
        String cronExpression = (String)source.get("cronExpression");
        if (experimentId == null || experimentId.equals("")) {
            throw new IllegalArgumentException("Invalid or missing experiment Id");
        }
        CronUtil.CronValidationResult validationResult = this.cronUtil.validateCron(cronExpression);
        if (!validationResult.isValid()) {
            throw new IllegalArgumentException(validationResult.getErrorMessage());
        }
        PostScheduledExperimentRequest createRequest = new PostScheduledExperimentRequest(experimentId, cronExpression);
        return channel -> client.execute((ActionType)PostScheduledExperimentAction.INSTANCE, (ActionRequest)createRequest, (ActionListener)new ActionListener<IndexResponse>(){

            public void onResponse(IndexResponse response) {
                try {
                    XContentBuilder builder = channel.newBuilder();
                    builder.startObject();
                    builder.field("job_id", response.getId());
                    builder.field("job_result", (Object)response.getResult());
                    builder.endObject();
                    channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, builder));
                }
                catch (IOException e) {
                    this.onFailure(e);
                }
            }

            public void onFailure(Exception e) {
                try {
                    channel.sendResponse((RestResponse)new BytesRestResponse(channel, ExceptionsHelper.status((Throwable)e), e));
                }
                catch (IOException ex) {
                    log.error("Failed to send error response", (Throwable)ex);
                }
            }
        });
    }

    @Generated
    public RestPostScheduledExperimentAction(SearchRelevanceSettingsAccessor settingsAccessor, CronUtil cronUtil) {
        this.settingsAccessor = settingsAccessor;
        this.cronUtil = cronUtil;
    }
}

