/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpx;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.sf.mpxj.DateOrder;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.ProjectTimeFormat;
import net.sf.mpxj.mpx.MPXJDateFormat;
import net.sf.mpxj.mpx.MPXJNumberFormat;
import net.sf.mpxj.mpx.MPXJTimeFormat;

public final class MPXJFormats {
    private Locale m_locale;
    private String m_nullText;
    private ProjectFile m_projectFile;
    private MPXJNumberFormat m_unitsDecimalFormat = new MPXJNumberFormat();
    private MPXJNumberFormat m_decimalFormat = new MPXJNumberFormat();
    private MPXJNumberFormat m_currencyFormat = new MPXJNumberFormat();
    private MPXJNumberFormat m_durationDecimalFormat = new MPXJNumberFormat();
    private MPXJNumberFormat m_percentageDecimalFormat = new MPXJNumberFormat();
    private MPXJDateFormat m_dateTimeFormat = new MPXJDateFormat();
    private MPXJDateFormat m_dateFormat = new MPXJDateFormat();
    private MPXJTimeFormat m_timeFormat = new MPXJTimeFormat();

    public MPXJFormats(Locale locale, String string, ProjectFile projectFile) {
        this.m_locale = locale;
        this.m_nullText = string;
        this.m_projectFile = projectFile;
        this.update();
    }

    public void update() {
        ProjectProperties projectProperties = this.m_projectFile.getProjectProperties();
        char c = projectProperties.getDecimalSeparator();
        char c2 = projectProperties.getThousandsSeparator();
        this.m_unitsDecimalFormat.applyPattern("#.##", null, c, c2);
        this.m_decimalFormat.applyPattern("0.00#", null, c, c2);
        this.m_durationDecimalFormat.applyPattern("#.##", null, c, c2);
        this.m_percentageDecimalFormat.applyPattern("##0.##", null, c, c2);
        this.updateCurrencyFormats(projectProperties, c, c2);
        this.updateDateTimeFormats(projectProperties);
    }

    private void updateCurrencyFormats(ProjectProperties projectProperties, char c, char c2) {
        String string;
        String string2;
        String string3;
        Object object = "";
        Object object2 = "";
        String string4 = this.quoteFormatCharacters(projectProperties.getCurrencySymbol());
        switch (projectProperties.getSymbolPosition()) {
            case AFTER: {
                object2 = string4;
                break;
            }
            case BEFORE: {
                object = string4;
                break;
            }
            case AFTER_WITH_SPACE: {
                object2 = " " + string4;
                break;
            }
            case BEFORE_WITH_SPACE: {
                object = string4 + " ";
            }
        }
        StringBuilder stringBuilder = new StringBuilder((String)object);
        stringBuilder.append("#0");
        int n = projectProperties.getCurrencyDigits();
        if (n > 0) {
            stringBuilder.append('.');
            for (int i = 0; i < n; ++i) {
                stringBuilder.append("0");
            }
        }
        stringBuilder.append((String)object2);
        String string5 = stringBuilder.toString();
        String[] stringArray = new String[7];
        stringArray[0] = string5 + ";(" + string5 + ")";
        stringBuilder.insert(((String)object).length(), "#,#");
        stringArray[1] = string3 = stringBuilder.toString();
        stringArray[2] = string3 + ";(" + string3 + ")";
        stringBuilder.setLength(0);
        stringBuilder.append("#0");
        if (n > 0) {
            stringBuilder.append('.');
            for (int i = 0; i < n; ++i) {
                stringBuilder.append("0");
            }
        }
        stringArray[3] = string2 = stringBuilder.toString();
        stringArray[4] = string2 + ";(" + string2 + ")";
        stringBuilder.insert(0, "#,#");
        stringArray[5] = string = stringBuilder.toString();
        stringArray[6] = string + ";(" + string + ")";
        this.m_currencyFormat.applyPattern(string5, stringArray, c, c2);
    }

    private String quoteFormatCharacters(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length();
        block3: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '#': 
                case '%': 
                case ',': 
                case '-': 
                case '.': 
                case '0': 
                case ';': 
                case 'E': {
                    stringBuilder.append("'");
                    stringBuilder.append(c);
                    stringBuilder.append("'");
                    continue block3;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    private void updateDateTimeFormats(ProjectProperties projectProperties) {
        String[] stringArray = this.getTimePatterns(projectProperties);
        String[] stringArray2 = this.getDatePatterns(projectProperties);
        String[] stringArray3 = this.getDateTimePatterns(projectProperties, stringArray);
        this.m_dateTimeFormat.applyPatterns(stringArray3);
        this.m_dateFormat.applyPatterns(stringArray2);
        this.m_timeFormat.applyPatterns(stringArray);
        this.m_dateTimeFormat.setLocale(this.m_locale);
        this.m_dateFormat.setLocale(this.m_locale);
        this.m_dateTimeFormat.setNullText(this.m_nullText);
        this.m_dateFormat.setNullText(this.m_nullText);
        this.m_timeFormat.setNullText(this.m_nullText);
        this.m_dateTimeFormat.setAmPmText(projectProperties.getAMText(), projectProperties.getPMText());
        this.m_timeFormat.setAmPmText(projectProperties.getAMText(), projectProperties.getPMText());
    }

    private String[] getDatePatterns(ProjectProperties projectProperties) {
        Object object = "";
        char c = projectProperties.getDateSeparator();
        DateOrder dateOrder = projectProperties.getDateOrder();
        switch (dateOrder) {
            case DMY: {
                object = "dd" + c + "MM" + c + "yy";
                break;
            }
            case MDY: {
                object = "MM" + c + "dd" + c + "yy";
                break;
            }
            case YMD: {
                object = "yy" + c + "MM" + c + "dd";
            }
        }
        return new String[]{object};
    }

    private String[] getDateTimePatterns(ProjectProperties projectProperties, String[] stringArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        char c = projectProperties.getDateSeparator();
        DateOrder dateOrder = projectProperties.getDateOrder();
        block0 : switch (projectProperties.getDateFormat()) {
            case DD_MM_YY_HH_MM: {
                switch (dateOrder) {
                    case DMY: {
                        arrayList.addAll(this.generateDateTimePatterns("dd" + c + "MM" + c + "yy", stringArray));
                        break;
                    }
                    case MDY: {
                        arrayList.addAll(this.generateDateTimePatterns("MM" + c + "dd" + c + "yy", stringArray));
                        break;
                    }
                    case YMD: {
                        arrayList.addAll(this.generateDateTimePatterns("yy" + c + "MM" + c + "dd", stringArray));
                    }
                }
                break;
            }
            case DD_MM_YY: {
                switch (dateOrder) {
                    case DMY: {
                        arrayList.add("dd" + c + "MM" + c + "yy");
                        break;
                    }
                    case MDY: {
                        arrayList.add("MM" + c + "dd" + c + "yy");
                        break;
                    }
                    case YMD: {
                        arrayList.add("yy" + c + "MM" + c + "dd");
                    }
                }
                break;
            }
            case DD_MMMMM_YYYY_HH_MM: {
                switch (dateOrder) {
                    case DMY: {
                        arrayList.addAll(this.generateDateTimePatterns("dd MMMMM yyyy", stringArray));
                        break;
                    }
                    case MDY: {
                        arrayList.addAll(this.generateDateTimePatterns("MMMMM dd yyyy", stringArray));
                        break;
                    }
                    case YMD: {
                        arrayList.addAll(this.generateDateTimePatterns("yyyy MMMMM dd", stringArray));
                    }
                }
                break;
            }
            case DD_MMMMM_YYYY: {
                switch (dateOrder) {
                    case DMY: {
                        arrayList.add("dd MMMMM yyyy");
                        break;
                    }
                    case MDY: {
                        arrayList.add("MMMMM dd yyyy");
                        break;
                    }
                    case YMD: {
                        arrayList.add("yyyy MMMMM dd");
                    }
                }
                break;
            }
            case DD_MMM_HH_MM: {
                switch (dateOrder) {
                    case DMY: {
                        arrayList.addAll(this.generateDateTimePatterns("dd MMM", stringArray));
                        break;
                    }
                    case MDY: 
                    case YMD: {
                        arrayList.addAll(this.generateDateTimePatterns("MMM dd", stringArray));
                    }
                }
                break;
            }
            case DD_MMM_YY: {
                switch (dateOrder) {
                    case DMY: {
                        arrayList.add("dd MMM ''yy");
                        break;
                    }
                    case MDY: {
                        arrayList.add("MMM dd ''yy");
                        break;
                    }
                    case YMD: {
                        arrayList.add("''yy MMM dd");
                    }
                }
                break;
            }
            case DD_MMMMM: {
                switch (dateOrder) {
                    case DMY: {
                        arrayList.add("dd MMMMM");
                        break;
                    }
                    case MDY: 
                    case YMD: {
                        arrayList.add("MMMMM dd");
                    }
                }
                break;
            }
            case DD_MMM: {
                switch (dateOrder) {
                    case DMY: {
                        arrayList.add("dd MMM");
                        break;
                    }
                    case MDY: 
                    case YMD: {
                        arrayList.add("MMM dd");
                    }
                }
                break;
            }
            case EEE_DD_MM_YY_HH_MM: {
                switch (dateOrder) {
                    case DMY: {
                        arrayList.addAll(this.generateDateTimePatterns("EEE dd" + c + "MM" + c + "yy", stringArray));
                        break;
                    }
                    case MDY: {
                        arrayList.addAll(this.generateDateTimePatterns("EEE MM" + c + "dd" + c + "yy", stringArray));
                        break;
                    }
                    case YMD: {
                        arrayList.addAll(this.generateDateTimePatterns("EEE yy" + c + "MM" + c + "dd", stringArray));
                    }
                }
                break;
            }
            case EEE_DD_MM_YY: {
                switch (dateOrder) {
                    case DMY: {
                        arrayList.add("EEE dd" + c + "MM" + c + "yy");
                        break;
                    }
                    case MDY: {
                        arrayList.add("EEE MM" + c + "dd" + c + "yy");
                        break;
                    }
                    case YMD: {
                        arrayList.add("EEE yy" + c + "MM" + c + "dd");
                    }
                }
                break;
            }
            case EEE_DD_MMM_YY: {
                switch (dateOrder) {
                    case DMY: {
                        arrayList.add("EEE dd MMM ''yy");
                        break;
                    }
                    case MDY: {
                        arrayList.add("EEE MMM dd ''yy");
                        break;
                    }
                    case YMD: {
                        arrayList.add("EEE ''yy MMM dd");
                    }
                }
                break;
            }
            case EEE_HH_MM: {
                arrayList.addAll(this.generateDateTimePatterns("EEE ", stringArray));
                break;
            }
            case DD_MM: {
                switch (dateOrder) {
                    case DMY: {
                        arrayList.add("dd" + c + "MM");
                        break;
                    }
                    case MDY: 
                    case YMD: {
                        arrayList.add("MM" + c + "dd");
                    }
                }
                break;
            }
            case DD: {
                arrayList.add("dd");
                break;
            }
            case HH_MM: {
                arrayList.addAll(Arrays.asList(stringArray));
                break;
            }
            case EEE_DD_MMM: {
                switch (dateOrder) {
                    case DMY: {
                        arrayList.add("EEE dd MMM");
                        break;
                    }
                    case MDY: 
                    case YMD: {
                        arrayList.add("EEE MMM dd");
                    }
                }
                break;
            }
            case EEE_DD_MM: {
                switch (dateOrder) {
                    case DMY: {
                        arrayList.add("EEE dd" + c + "MM");
                        break;
                    }
                    case MDY: 
                    case YMD: {
                        arrayList.add("EEE MM" + c + "dd");
                    }
                }
                break;
            }
            case EEE_DD: {
                arrayList.add("EEE dd");
                break;
            }
            case DD_WWW: {
                arrayList.add("F" + c + "'W'ww");
                break;
            }
            case DD_WWW_YY_HH_MM: {
                arrayList.addAll(this.generateDateTimePatterns("F" + c + "'W'ww" + c + "yy", stringArray));
                break;
            }
            case DD_MM_YYYY: {
                switch (dateOrder) {
                    case DMY: {
                        arrayList.add("dd" + c + "MM" + c + "yyyy");
                        break block0;
                    }
                    case MDY: {
                        arrayList.add("MM" + c + "dd" + c + "yyyy");
                        break block0;
                    }
                    case YMD: {
                        arrayList.add("yyyy" + c + "MM" + c + "dd");
                    }
                }
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private List<String> generateDateTimePatterns(String string, String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : stringArray) {
            arrayList.add(string + " " + string2);
        }
        arrayList.add(string);
        return arrayList;
    }

    private String[] getTimePatterns(ProjectProperties projectProperties) {
        char c = projectProperties.getTimeSeparator();
        ProjectTimeFormat projectTimeFormat = projectProperties.getTimeFormat();
        String[] stringArray = projectTimeFormat == null || projectTimeFormat == ProjectTimeFormat.TWELVE_HOUR ? new String[]{"hh" + c + "mm a", "hh" + c + "mma"} : new String[]{"HH" + c + "mm", "HH"};
        return stringArray;
    }

    public NumberFormat getUnitsDecimalFormat() {
        return this.m_unitsDecimalFormat;
    }

    public NumberFormat getDecimalFormat() {
        return this.m_decimalFormat;
    }

    public NumberFormat getCurrencyFormat() {
        return this.m_currencyFormat;
    }

    public NumberFormat getDurationDecimalFormat() {
        return this.m_durationDecimalFormat;
    }

    public NumberFormat getPercentageDecimalFormat() {
        return this.m_percentageDecimalFormat;
    }

    public DateFormat getDateTimeFormat() {
        return this.m_dateTimeFormat;
    }

    public DateFormat getDateFormat() {
        return this.m_dateFormat;
    }

    public DateFormat getTimeFormat() {
        return this.m_timeFormat;
    }

    public String getNullText() {
        return this.m_nullText;
    }
}

