/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.geocoder;

import jakarta.json.JsonObject;
import jakarta.ws.rs.client.Client;
import org.traccar.geocoder.Address;
import org.traccar.geocoder.AddressFormat;
import org.traccar.geocoder.JsonGeocoder;

public class NominatimGeocoder
extends JsonGeocoder {
    private static String formatUrl(String url, String key, String language) {
        if (url == null) {
            url = "https://nominatim.openstreetmap.org/reverse";
        }
        url = (String)url + "?format=json&lat=%f&lon=%f&zoom=18&addressdetails=1";
        if (key != null) {
            url = (String)url + "&key=" + key;
        }
        if (language != null) {
            url = (String)url + "&accept-language=" + language;
        }
        return url;
    }

    public NominatimGeocoder(Client client, String url, String key, String language, int cacheSize, AddressFormat addressFormat) {
        super(client, NominatimGeocoder.formatUrl(url, key, language), cacheSize, addressFormat);
    }

    @Override
    public Address parseAddress(JsonObject json) {
        JsonObject result = json.getJsonObject("address");
        if (result != null) {
            Address address = new Address();
            if (json.containsKey((Object)"display_name")) {
                address.setFormattedAddress(json.getString("display_name"));
            }
            if (result.containsKey((Object)"house_number")) {
                address.setHouse(result.getString("house_number"));
            }
            if (result.containsKey((Object)"road")) {
                address.setStreet(result.getString("road"));
            }
            if (result.containsKey((Object)"suburb")) {
                address.setSuburb(result.getString("suburb"));
            }
            if (result.containsKey((Object)"village")) {
                address.setSettlement(result.getString("village"));
            } else if (result.containsKey((Object)"town")) {
                address.setSettlement(result.getString("town"));
            } else if (result.containsKey((Object)"city")) {
                address.setSettlement(result.getString("city"));
            }
            if (result.containsKey((Object)"state_district")) {
                address.setDistrict(result.getString("state_district"));
            } else if (result.containsKey((Object)"region")) {
                address.setDistrict(result.getString("region"));
            }
            if (result.containsKey((Object)"state")) {
                address.setState(result.getString("state"));
            }
            if (result.containsKey((Object)"country_code")) {
                address.setCountry(result.getString("country_code").toUpperCase());
            }
            if (result.containsKey((Object)"postcode")) {
                address.setPostcode(result.getString("postcode"));
            }
            return address;
        }
        return null;
    }
}

