/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.handler.network;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.DatagramPacket;
import jakarta.inject.Inject;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.traccar.forward.NetworkForwarder;

public class NetworkForwarderHandler
extends ChannelInboundHandlerAdapter {
    private final int port;
    private NetworkForwarder networkForwarder;

    public NetworkForwarderHandler(int port) {
        this.port = port;
    }

    @Inject
    public void setNetworkForwarder(NetworkForwarder networkForwarder) {
        this.networkForwarder = networkForwarder;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        ByteBuf buffer;
        SocketAddress remoteAddress;
        boolean datagram = ctx.channel() instanceof DatagramChannel;
        if (datagram) {
            DatagramPacket message = (DatagramPacket)msg;
            remoteAddress = message.recipient();
            buffer = (ByteBuf)message.content();
        } else {
            remoteAddress = ctx.channel().remoteAddress();
            buffer = (ByteBuf)msg;
        }
        byte[] data = new byte[buffer.readableBytes()];
        buffer.getBytes(buffer.readerIndex(), data);
        this.networkForwarder.forward((InetSocketAddress)remoteAddress, this.port, datagram, data);
        super.channelRead(ctx, msg);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (!(ctx.channel() instanceof DatagramChannel)) {
            this.networkForwarder.disconnect((InetSocketAddress)ctx.channel().remoteAddress());
        }
        super.channelInactive(ctx);
    }
}

