/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.helper;

public final class UnitsConverter {
    private static final double KNOTS_TO_KPH_RATIO = 0.539957;
    private static final double KNOTS_TO_MPH_RATIO = 0.868976;
    private static final double KNOTS_TO_MPS_RATIO = 1.94384;
    private static final double KNOTS_TO_CPS_RATIO = 0.0194384449;
    private static final double METERS_TO_FEET_RATIO = 0.3048;
    private static final double METERS_TO_MILE_RATIO = 1609.34;
    private static final long MILLISECONDS_TO_HOURS_RATIO = 3600000L;
    private static final long MILLISECONDS_TO_MINUTES_RATIO = 60000L;

    private UnitsConverter() {
    }

    public static double knotsFromKph(double value) {
        return value * 0.539957;
    }

    public static double kphFromKnots(double value) {
        return value / 0.539957;
    }

    public static double knotsFromMph(double value) {
        return value * 0.868976;
    }

    public static double mphFromKnots(double value) {
        return value / 0.868976;
    }

    public static double knotsFromMps(double value) {
        return value * 1.94384;
    }

    public static double mpsFromKnots(double value) {
        return value / 1.94384;
    }

    public static double knotsFromCps(double value) {
        return value * 0.0194384449;
    }

    public static double feetFromMeters(double value) {
        return value / 0.3048;
    }

    public static double metersFromFeet(double value) {
        return value * 0.3048;
    }

    public static double milesFromMeters(double value) {
        return value / 1609.34;
    }

    public static double metersFromMiles(double value) {
        return value * 1609.34;
    }

    public static long msFromHours(long value) {
        return value * 3600000L;
    }

    public static long msFromHours(double value) {
        return (long)(value * 3600000.0);
    }

    public static long msFromMinutes(long value) {
        return value * 60000L;
    }
}

