/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.exceloutput;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.biff.DisplayFormat;
import jxl.format.CellFormat;
import jxl.write.DateFormat;
import jxl.write.DateFormats;
import jxl.write.DateTime;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.NumberFormat;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.exceloutput.ExcelField;
import org.pentaho.di.trans.steps.exceloutput.ExcelOutputData;
import org.pentaho.di.trans.steps.exceloutput.ExcelOutputMeta;
import org.pentaho.di.trans.steps.exceloutput.Messages;

public class ExcelOutput
extends BaseStep
implements StepInterface {
    private ExcelOutputMeta meta;
    private ExcelOutputData data;

    public ExcelOutput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (ExcelOutputMeta)smi;
        this.data = (ExcelOutputData)sdi;
        Object[] r = this.getRow();
        if (this.first && r != null) {
            this.data.previousMeta = this.getInputRowMeta().clone();
            if (this.meta.isAutoSizeColums()) {
                this.data.fieldsWidth = this.meta.getOutputFields() != null && this.meta.getOutputFields().length > 0 ? new int[this.meta.getOutputFields().length] : new int[this.data.previousMeta.size()];
            }
            if (this.meta.isDoNotOpenNewFileInit()) {
                this.data.oneFileOpened = true;
                if (!this.openNewFile()) {
                    this.logError("Couldn't open file " + this.buildFilename());
                    return false;
                }
                if (this.meta.isHeaderEnabled() && !this.data.headerWrote) {
                    this.writeHeader();
                    this.data.headerWrote = true;
                }
            } else if (this.meta.isHeaderEnabled() && !this.data.headerWrote) {
                this.writeHeader();
                this.data.headerWrote = true;
            }
        }
        if (r != null && this.getLinesOutput() > 0L && this.meta.getSplitEvery() > 0 && (this.getLinesOutput() + 1L) % (long)this.meta.getSplitEvery() == 0L && r != null) {
            this.closeFile();
            if (!this.openNewFile()) {
                this.logError("Unable to open new file (split #" + this.data.splitnr + "...");
                this.setErrors(1L);
                return false;
            }
            if (this.meta.isHeaderEnabled() && !this.data.headerWrote) {
                this.writeHeader();
                this.data.headerWrote = true;
            }
        }
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        boolean result = this.writeRowToFile(r);
        if (!result) {
            this.setErrors(1L);
            this.stopAll();
            return false;
        }
        this.putRow(this.data.previousMeta, r);
        if (this.checkFeedback(this.getLinesOutput()) && this.log.isBasic()) {
            this.logBasic("linenr " + this.getLinesOutput());
        }
        return result;
    }

    private boolean writeRowToFile(Object[] r) {
        try {
            int i;
            if (this.first) {
                this.first = false;
                this.data.fieldnrs = new int[this.meta.getOutputFields().length];
                for (i = 0; i < this.meta.getOutputFields().length; ++i) {
                    this.data.fieldnrs[i] = this.data.previousMeta.indexOfValue(this.meta.getOutputFields()[i].getName());
                    if (this.data.fieldnrs[i] >= 0) continue;
                    this.logError("Field [" + this.meta.getOutputFields()[i].getName() + "] couldn't be found in the input stream!");
                    this.setErrors(1L);
                    this.stopAll();
                    return false;
                }
            }
            if (this.meta.getOutputFields() == null || this.meta.getOutputFields().length == 0) {
                for (i = 0; i < this.data.previousMeta.size(); ++i) {
                    Object v = r[i];
                    if (this.writeField(v, this.data.previousMeta.getValueMeta(i), null, i)) continue;
                    return false;
                }
                this.data.positionX = 0;
                ++this.data.positionY;
            } else {
                for (i = 0; i < this.meta.getOutputFields().length; ++i) {
                    Object v = r[this.data.fieldnrs[i]];
                    if (this.writeField(v, this.data.previousMeta.getValueMeta(this.data.fieldnrs[i]), this.meta.getOutputFields()[i], i)) continue;
                    return false;
                }
                this.data.positionX = 0;
                ++this.data.positionY;
            }
        }
        catch (Exception e) {
            this.logError("Error writing line :" + e.toString());
            return false;
        }
        this.incrementLinesOutput();
        return true;
    }

    private boolean writeField(Object v, ValueMetaInterface vMeta, ExcelField excelField, int column) {
        return this.writeField(v, vMeta, excelField, column, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean writeField(Object v, ValueMetaInterface vMeta, ExcelField excelField, int column, boolean isHeader) {
        WritableFont writableFont = new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD);
        try {
            try {
                WritableCellFormat cellFormat;
                String hashName = vMeta.getName();
                if (isHeader) {
                    hashName = "____header_field____";
                }
                if ((cellFormat = this.data.formats.get(hashName)) == null && this.meta.isTemplateEnabled() && !isHeader) {
                    try {
                        if (column < this.data.templateColumns) {
                            cellFormat = new WritableCellFormat(this.data.sheet.getColumnView(column).getFormat());
                            this.data.formats.put(hashName, cellFormat);
                        }
                    }
                    catch (RuntimeException e) {
                        // empty catch block
                    }
                }
                if (this.meta.isAutoSizeColums()) {
                    int vlen = vMeta.getName().length();
                    if (!isHeader && v != null) {
                        vlen = v.toString().trim().length();
                    }
                    if (vlen > 0 && vlen > this.data.fieldsWidth[column]) {
                        this.data.fieldsWidth[column] = vlen + 1;
                    }
                }
                switch (vMeta.getType()) {
                    case 3: {
                        if (v != null && vMeta.getDate(v) != null) {
                            if (cellFormat == null) {
                                if (excelField != null && excelField.getFormat() != null) {
                                    DateFormat dateFormat = new DateFormat(excelField.getFormat());
                                    cellFormat = new WritableCellFormat((DisplayFormat)dateFormat);
                                } else {
                                    cellFormat = new WritableCellFormat(DateFormats.FORMAT9);
                                }
                                this.data.formats.put(hashName, cellFormat);
                            }
                            DateTime dateTime = new DateTime(this.data.positionX, this.data.positionY, vMeta.getDate(v), (CellFormat)cellFormat);
                            this.data.sheet.addCell((WritableCell)dateTime);
                            break;
                        }
                        this.data.sheet.addCell((WritableCell)new Label(this.data.positionX, this.data.positionY, ""));
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 8: {
                        if (v != null) {
                            if (cellFormat == null) {
                                cellFormat = new WritableCellFormat(writableFont);
                                this.data.formats.put(hashName, cellFormat);
                            }
                            Label label = new Label(this.data.positionX, this.data.positionY, vMeta.getString(v), (CellFormat)cellFormat);
                            this.data.sheet.addCell((WritableCell)label);
                            break;
                        }
                        this.data.sheet.addCell((WritableCell)new Label(this.data.positionX, this.data.positionY, ""));
                        break;
                    }
                    case 1: 
                    case 5: 
                    case 6: {
                        if (v != null) {
                            if (cellFormat == null) {
                                String format = excelField != null && excelField.getFormat() != null ? excelField.getFormat() : "###,###.00";
                                NumberFormat numberFormat = new NumberFormat(format);
                                cellFormat = new WritableCellFormat((DisplayFormat)numberFormat);
                                this.data.formats.put(vMeta.getName(), cellFormat);
                            }
                            Number number = new Number(this.data.positionX, this.data.positionY, vMeta.getNumber(v).doubleValue(), (CellFormat)cellFormat);
                            this.data.sheet.addCell((WritableCell)number);
                            break;
                        }
                        this.data.sheet.addCell((WritableCell)new Label(this.data.positionX, this.data.positionY, ""));
                        break;
                    }
                }
            }
            catch (Exception e) {
                this.logError("Error writing field (" + this.data.positionX + "," + this.data.positionY + ") : " + e.toString());
                this.logError(Const.getStackTracker((Throwable)e));
                boolean bl = false;
                Object var12_18 = null;
                ++this.data.positionX;
                return bl;
            }
            {
            }
            Object var12_17 = null;
            ++this.data.positionX;
            return true;
        }
        catch (Throwable throwable) {
            Object var12_19 = null;
            ++this.data.positionX;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeHeader() {
        boolean retval = false;
        try {
            try {
                if (this.meta.getOutputFields() != null && this.meta.getOutputFields().length > 0) {
                    for (int i = 0; i < this.meta.getOutputFields().length; ++i) {
                        String fieldName = this.meta.getOutputFields()[i].getName();
                        ValueMeta vMeta = new ValueMeta(fieldName, 2);
                        this.writeField(fieldName, (ValueMetaInterface)vMeta, null, i, true);
                    }
                } else if (this.data.previousMeta != null) {
                    for (int i = 0; i < this.data.previousMeta.size(); ++i) {
                        String fieldName = this.data.previousMeta.getFieldNames()[i];
                        ValueMeta vMeta = new ValueMeta(fieldName, 2);
                        this.writeField(fieldName, (ValueMetaInterface)vMeta, null, i, true);
                    }
                }
                Object var6_9 = null;
                this.data.positionX = 0;
                ++this.data.positionY;
            }
            catch (Exception e) {
                this.logError("Error writing header line: " + e.toString());
                this.logError(Const.getStackTracker((Throwable)e));
                retval = true;
                Object var6_10 = null;
                this.data.positionX = 0;
                ++this.data.positionY;
            }
        }
        catch (Throwable throwable) {
            Object var6_11 = null;
            this.data.positionX = 0;
            ++this.data.positionY;
            throw throwable;
        }
        this.incrementLinesOutput();
        return retval;
    }

    public String buildFilename() {
        return this.meta.buildFilename(this, this.getCopy(), this.data.splitnr);
    }

    public boolean openNewFile() {
        boolean retval = false;
        try {
            WorkbookSettings ws = new WorkbookSettings();
            ws.setLocale(Locale.getDefault());
            if (!Const.isEmpty((String)this.meta.getEncoding())) {
                ws.setEncoding(this.meta.getEncoding());
            }
            String buildFilename = this.buildFilename();
            this.data.file = KettleVFS.getFileObject((String)buildFilename);
            if (this.log.isDebug()) {
                this.log.logDebug(this.toString(), Messages.getString("ExcelOutput.Log.OpeningFile", buildFilename), new Object[0]);
            }
            if (this.meta.isAddToResultFiles()) {
                ResultFile resultFile = new ResultFile(0, this.data.file, this.getTransMeta().getName(), this.getStepname());
                resultFile.setComment("This file was created with an Excel output step by Pentaho Data Integration");
                this.addResultFile(resultFile);
            }
            if (!this.meta.isTemplateEnabled()) {
                File fle = new File(KettleVFS.getFilename((FileObject)this.data.file));
                if (this.meta.isAppend() && fle.exists()) {
                    Workbook workbook = Workbook.getWorkbook((File)fle);
                    this.data.workbook = Workbook.createWorkbook((File)fle, (Workbook)workbook);
                    if (workbook != null) {
                        workbook.close();
                    }
                    if (this.data.workbook.getSheet(this.data.realSheetname) != null) {
                        String[] listSheets = this.data.workbook.getSheetNames();
                        for (int i = 0; i < listSheets.length; ++i) {
                            if (!listSheets[i].equals(this.data.realSheetname)) continue;
                            this.data.workbook.removeSheet(i);
                        }
                    }
                    this.data.sheet = this.data.workbook.createSheet(this.data.realSheetname, this.data.workbook.getNumberOfSheets());
                } else {
                    this.data.workbook = Workbook.createWorkbook((OutputStream)KettleVFS.getOutputStream((FileObject)this.data.file, (boolean)false), (WorkbookSettings)ws);
                    String sheetname = "Sheet1";
                    this.data.sheet = this.data.workbook.getSheet(sheetname);
                    if (this.data.sheet == null) {
                        this.data.sheet = this.data.workbook.createSheet(sheetname, 0);
                    }
                }
            } else {
                FileObject fo = KettleVFS.getFileObject((String)this.environmentSubstitute(this.meta.getTemplateFileName()));
                Workbook tmpWorkbook = Workbook.getWorkbook((InputStream)KettleVFS.getInputStream((FileObject)fo), (WorkbookSettings)ws);
                this.data.workbook = Workbook.createWorkbook((OutputStream)KettleVFS.getOutputStream((FileObject)this.data.file, (boolean)false), (Workbook)tmpWorkbook);
                tmpWorkbook.close();
                this.data.sheet = this.data.workbook.getSheet(0);
                this.data.templateColumns = this.data.sheet.getColumns();
            }
            if (!Const.isEmpty((String)this.data.realSheetname)) {
                this.data.sheet.setName(this.data.realSheetname);
            }
            if (this.meta.isSheetProtected()) {
                this.data.sheet.getSettings().setProtected(true);
                this.data.sheet.getSettings().setPassword(this.environmentSubstitute(this.meta.getPassword()));
            }
            this.data.positionX = 0;
            this.data.positionY = this.meta.isTemplateEnabled() && this.meta.isTemplateAppend() ? this.data.sheet.getRows() : 0;
            this.data.headerWrote = false;
            if (this.log.isDebug()) {
                this.log.logDebug(this.toString(), Messages.getString("ExcelOutput.Log.FileOpened", buildFilename), new Object[0]);
            }
            retval = true;
        }
        catch (Exception e) {
            this.logError("Error opening new file", e);
            this.setErrors(1L);
        }
        ++this.data.splitnr;
        return retval;
    }

    private boolean closeFile() {
        boolean retval = false;
        String filename = null;
        try {
            if (this.meta.isFooterEnabled()) {
                this.writeHeader();
            }
            if (this.data.workbook != null) {
                if (this.meta.isAutoSizeColums()) {
                    int nrfields = this.data.fieldsWidth.length;
                    for (int i = 0; i < nrfields; ++i) {
                        this.data.sheet.setColumnView(i, this.data.fieldsWidth[i]);
                    }
                }
                this.data.fieldsWidth = null;
                this.data.workbook.write();
                this.data.workbook.close();
                this.data.workbook = null;
                if (this.data.outputStream != null) {
                    this.data.outputStream.close();
                    this.data.outputStream = null;
                }
                if (this.data.sheet != null) {
                    this.data.sheet = null;
                }
                if (this.data.file != null) {
                    filename = this.data.file.toString();
                    this.data.file.close();
                    this.data.file = null;
                }
            }
            if (this.log.isDebug()) {
                this.log.logDebug(this.toString(), Messages.getString("ExcelOutput.Log.FileClosed", filename), new Object[0]);
            }
            System.gc();
            retval = true;
        }
        catch (Exception e) {
            this.logError("Unable to close openFile file : " + this.data.file.toString(), e);
            this.setErrors(1L);
        }
        return retval;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (ExcelOutputMeta)smi;
        this.data = (ExcelOutputData)sdi;
        if (super.init(smi, sdi)) {
            this.data.splitnr = 0;
            this.data.realSheetname = this.environmentSubstitute(this.meta.getSheetname());
            if (!this.meta.isDoNotOpenNewFileInit()) {
                this.data.oneFileOpened = true;
                if (this.openNewFile()) {
                    return true;
                }
                this.logError("Couldn't open file " + this.meta.getFileName());
                this.setErrors(1L);
                this.stopAll();
            } else {
                return true;
            }
        }
        return false;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (ExcelOutputMeta)smi;
        this.data = (ExcelOutputData)sdi;
        if (this.data.oneFileOpened) {
            this.closeFile();
        }
        if (this.data.file != null) {
            try {
                this.data.file.close();
                this.data.file = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.dispose(smi, sdi);
    }

    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }
}

