/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.dialog;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.ChoiceItem;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.dialog.FreeColDialog;
import net.sf.freecol.client.gui.panel.MapEditorTransformPanel;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.client.gui.plaf.FreeColComboBoxRenderer;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.IndianNationType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.SettlementType;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.RandomChoice;
import net.sf.freecol.server.model.ServerUnit;

public final class EditSettlementDialog
extends FreeColDialog<IndianSettlement>
implements ItemListener {
    private static final Logger logger = Logger.getLogger(EditSettlementDialog.class.getName());
    private final IndianSettlement is;
    private final JTextField name;
    private final JComboBox<Nation> owner;
    private final JCheckBox capital;
    private final JComboBox<UnitType> skill;
    private final JSpinner units;

    public EditSettlementDialog(FreeColClient freeColClient, JFrame frame, IndianSettlement is) {
        super(freeColClient, frame);
        this.is = is;
        this.name = new JTextField(is.getName(), 30);
        DefaultComboBoxModel<Nation> nationModel = new DefaultComboBoxModel<Nation>();
        for (Nation n : this.getSpecification().getIndianNations()) {
            nationModel.addElement(n);
        }
        this.owner = new JComboBox(nationModel);
        this.owner.setSelectedItem(is.getOwner().getNation());
        this.owner.addItemListener(this);
        this.owner.setRenderer(new FreeColComboBoxRenderer());
        this.capital = new JCheckBox();
        this.capital.setSelected(is.isCapital());
        this.skill = new JComboBox<UnitType>(this.getSkillModel());
        this.skill.setSelectedItem(is.getLearnableSkill());
        this.skill.setRenderer(new FreeColComboBoxRenderer());
        int unitCount = is.getUnitCount();
        SpinnerNumberModel spinnerModel = new SpinnerNumberModel(unitCount, 1, 20, 1);
        this.units = new JSpinner(spinnerModel);
        spinnerModel.setValue(unitCount);
        MigPanel panel = new MigPanel(new MigLayout("wrap 2, gapx 20"));
        panel.add(Utility.localizedLabel("name"));
        panel.add(this.name);
        panel.add(Utility.localizedLabel("nation"));
        panel.add(this.owner);
        panel.add(Utility.localizedLabel("capital"));
        panel.add(this.capital);
        panel.add(Utility.localizedLabel("skillTaught"));
        panel.add(this.skill);
        panel.add(Utility.localizedLabel("units"));
        panel.add(this.units);
        List c = EditSettlementDialog.choices();
        c.add(new ChoiceItem<IndianSettlement>(Messages.message("ok"), is).okOption());
        c.add(new ChoiceItem<Object>(Messages.message("editSettlementDialog.removeSettlement"), null));
        c.add(new ChoiceItem<IndianSettlement>(Messages.message("cancel"), null).cancelOption().defaultOption());
        this.initializeDialog(frame, FreeColDialog.DialogType.QUESTION, true, panel, new ImageIcon(this.getImageLibrary().getSmallSettlementImage(is)), c);
    }

    private Nation getOwnerNation() {
        return (Nation)this.owner.getSelectedItem();
    }

    private IndianNationType getOwnerNationType() {
        Nation n = this.getOwnerNation();
        return n == null ? null : (IndianNationType)n.getType();
    }

    private Player getOwnerPlayer() {
        return this.is.getGame().getPlayerByNation(this.getOwnerNation());
    }

    private SettlementType getSettlementType() {
        return this.getOwnerNationType().getSettlementType(this.capital.isSelected());
    }

    private DefaultComboBoxModel<UnitType> getSkillModel() {
        IndianNationType ownerType = this.getOwnerNationType();
        DefaultComboBoxModel<UnitType> skillModel = new DefaultComboBoxModel<UnitType>();
        for (RandomChoice<UnitType> skill : ownerType.getSkills()) {
            skillModel.addElement(skill.getObject());
        }
        return skillModel;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Player player = this.getOwnerPlayer();
        if (player != null) {
            this.name.setText(this.capital.isSelected() ? player.getCapitalName(null) : player.getSettlementName(null));
        }
        this.skill.setModel(this.getSkillModel());
        this.skill.setSelectedItem(this.is.getLearnableSkill());
        this.units.getModel().setValue(this.is.getUnitCount());
    }

    @Override
    public IndianSettlement getResponse() {
        Specification spec = this.freeColClient.getGame().getSpecification();
        GUI gui = this.getGUI();
        IndianSettlement ret = null;
        Set<Tile> tiles = this.is.getOwnedTiles();
        Object value = this.getValue();
        if (((ChoiceItem)this.options.get(0)).equals(value)) {
            this.is.setName(this.name.getText());
            Nation newNation = this.getOwnerNation();
            if (newNation != this.is.getOwner().getNation()) {
                Player newPlayer = this.getOwnerPlayer();
                this.is.setOwner(newPlayer);
                for (Unit u : this.is.getAllUnitsList()) {
                    u.setOwner(newPlayer);
                    u.setEthnicity(newNation.getId());
                    u.setNationality(newNation.getId());
                }
                for (Tile t : this.is.getOwnedTiles()) {
                    t.setOwner(newPlayer);
                }
                MapEditorTransformPanel.setNativeNation(newNation);
            }
            if (this.capital.isSelected() && !this.is.isCapital()) {
                for (IndianSettlement indianSettlement : this.is.getOwner().getIndianSettlementList()) {
                    indianSettlement.setCapital(false);
                }
                this.is.setCapital(true);
            } else if (!this.capital.isSelected() && this.is.isCapital()) {
                this.is.setCapital(false);
            }
            this.is.setLearnableSkill((UnitType)this.skill.getSelectedItem());
            int numberOfUnits = (Integer)this.units.getValue() - this.is.getUnitCount();
            if (numberOfUnits > 0) {
                Player owner = this.is.getOwner();
                UnitType brave = spec.getDefaultUnitType(owner);
                for (int index = 0; index < numberOfUnits; ++index) {
                    this.is.add(new ServerUnit(this.is.getGame(), this.is, owner, brave));
                }
            } else if (numberOfUnits < 0) {
                List<Unit> unitList = this.is.getUnitList().subList(0, -numberOfUnits);
                for (Unit unit : unitList) {
                    unit.dispose();
                }
            }
            SettlementType oldType = this.is.getType();
            SettlementType type = this.getSettlementType();
            this.is.setType(type);
            this.is.getFeatureContainer().replaceSource(oldType, type);
            ret = this.is;
        } else if (((ChoiceItem)this.options.get(1)).equals(value)) {
            if (!gui.confirm("editSettlementDialog.removeSettlement.text", "ok", "cancel")) {
                return this.is;
            }
            Tile tile = this.is.getTile();
            for (Unit unit : tile.getUnitList()) {
                unit.dispose();
            }
            this.is.exciseSettlement();
        }
        return ret;
    }
}

