/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel.socks;

import java.util.Arrays;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.util.Addresses;

public class SOCKSHeader {
    private byte[] header;
    private static final byte[] beg = new byte[]{0, 0, 0, 3, 60};

    public SOCKSHeader(byte[] data) {
        if (data.length <= 8) {
            throw new IllegalArgumentException("Header too short: " + data.length);
        }
        if (data[0] != 0 || data[1] != 0) {
            throw new IllegalArgumentException("Not a SOCKS datagram?");
        }
        if (data[2] != 0) {
            throw new IllegalArgumentException("We can't handle fragments!");
        }
        int headerlen = 0;
        byte addressType = data[3];
        if (addressType == 1) {
            headerlen = 10;
        } else if (addressType == 3) {
            headerlen = 7 + (data[4] & 0xFF);
        } else if (addressType == 4) {
            headerlen = 22;
        } else {
            throw new IllegalArgumentException("Unknown address type: " + addressType);
        }
        if (data.length < headerlen) {
            throw new IllegalArgumentException("Header too short: " + data.length);
        }
        this.header = new byte[headerlen];
        System.arraycopy(data, 0, this.header, 0, headerlen);
    }

    public SOCKSHeader(Destination dest, int port) {
        this.header = new byte[beg.length + 60 + 2];
        System.arraycopy(beg, 0, this.header, 0, beg.length);
        String b32 = dest.toBase32();
        System.arraycopy(DataHelper.getASCII(b32), 0, this.header, beg.length, 60);
        DataHelper.toLong(this.header, beg.length + 60, 2, port);
    }

    public String getHost() {
        byte addressType = this.header[3];
        if (addressType == 3) {
            int namelen = this.header[4] & 0xFF;
            return DataHelper.getUTF8(this.header, 5, namelen);
        }
        if (addressType == 1) {
            return Addresses.toString(Arrays.copyOfRange(this.header, 4, 4));
        }
        if (addressType == 4) {
            return Addresses.toString(Arrays.copyOfRange(this.header, 4, 16));
        }
        return null;
    }

    public int getPort() {
        int namelen;
        byte addressType = this.header[3];
        if (addressType == 3) {
            namelen = 1 + (this.header[4] & 0xFF);
        } else if (addressType == 1) {
            namelen = 4;
        } else if (addressType == 4) {
            namelen = 16;
        } else {
            return 0;
        }
        return (int)DataHelper.fromLong(this.header, 4 + namelen, 2);
    }

    public Destination getDestination() {
        String name = this.getHost();
        if (name == null) {
            return null;
        }
        return I2PAppContext.getGlobalContext().namingService().lookup(name);
    }

    public byte[] getBytes() {
        return this.header;
    }
}

