/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gradle.toolingExtension.impl.model.projectModel;

import com.intellij.gradle.toolingExtension.impl.util.GradleIdeaPluginUtil;
import com.intellij.gradle.toolingExtension.impl.util.GradleObjectUtil;
import com.intellij.gradle.toolingExtension.impl.util.GradleProjectUtil;
import org.gradle.api.Project;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.DefaultExternalProject;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.tooling.AbstractModelBuilderService;
import org.jetbrains.plugins.gradle.tooling.Message;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderContext;

@ApiStatus.Internal
public class GradleExternalProjectModelBuilder
extends AbstractModelBuilderService {
    public boolean canBuild(@NotNull String modelName) {
        if (modelName == null) {
            GradleExternalProjectModelBuilder.$$$reportNull$$$0(0);
        }
        return ExternalProject.class.getName().equals(modelName);
    }

    @Nullable
    public Object buildAll(@NotNull String modelName, @NotNull Project project, @NotNull ModelBuilderContext context) {
        if (modelName == null) {
            GradleExternalProjectModelBuilder.$$$reportNull$$$0(1);
        }
        if (project == null) {
            GradleExternalProjectModelBuilder.$$$reportNull$$$0(2);
        }
        if (context == null) {
            GradleExternalProjectModelBuilder.$$$reportNull$$$0(3);
        }
        String projectPath = project.getPath();
        String projectName = project.getName();
        String projectIdentityPath = GradleObjectUtil.notNull(GradleProjectUtil.getProjectIdentityPath(project), projectPath);
        String ideaModuleName = GradleObjectUtil.notNull(GradleIdeaPluginUtil.getIdeaModuleName(project), projectName);
        DefaultExternalProject externalProject = new DefaultExternalProject();
        externalProject.setExternalSystemId("GRADLE");
        externalProject.setName(projectName);
        externalProject.setQName(":".equals(projectPath) ? projectName : projectPath);
        externalProject.setId(":".equals(projectIdentityPath) ? ideaModuleName : projectIdentityPath);
        externalProject.setPath(projectPath);
        externalProject.setIdentityPath(projectIdentityPath);
        externalProject.setVersion(GradleExternalProjectModelBuilder.wrap(project.getVersion()));
        externalProject.setDescription(project.getDescription());
        externalProject.setBuildDir(GradleProjectUtil.getBuildDirectory(project));
        externalProject.setBuildFile(project.getBuildFile());
        externalProject.setGroup(GradleExternalProjectModelBuilder.wrap(project.getGroup()));
        externalProject.setProjectDir(project.getProjectDir());
        return externalProject;
    }

    @NotNull
    private static String wrap(@Nullable Object o) {
        return o instanceof CharSequence ? o.toString() : "";
    }

    public void reportErrorMessage(@NotNull String modelName, @NotNull Project project, @NotNull ModelBuilderContext context, @NotNull Exception exception) {
        if (modelName == null) {
            GradleExternalProjectModelBuilder.$$$reportNull$$$0(4);
        }
        if (project == null) {
            GradleExternalProjectModelBuilder.$$$reportNull$$$0(5);
        }
        if (context == null) {
            GradleExternalProjectModelBuilder.$$$reportNull$$$0(6);
        }
        if (exception == null) {
            GradleExternalProjectModelBuilder.$$$reportNull$$$0(7);
        }
        context.getMessageReporter().createMessage().withGroup("gradle.projectModel.group").withKind(Message.Kind.ERROR).withTitle("Project model building failure").withText("Project structure cannot be resolved").withException(exception).reportMessage(project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelName";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exception";
                break;
            }
        }
        objectArray2[1] = "com/intellij/gradle/toolingExtension/impl/model/projectModel/GradleExternalProjectModelBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canBuild";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "buildAll";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "reportErrorMessage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

