/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.threadview;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.CommonProfilerUISettings;
import com.intellij.profiler.CommonProfilerUiOptions;
import com.intellij.profiler.ThreadListOptions;
import com.intellij.profiler.statistics.ProfilerUsageTriggerCollector;
import com.intellij.profiler.ui.threadview.ThreadList;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.OnePixelSplitter;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0015\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"Lcom/intellij/profiler/ui/threadview/ToggleThreadListAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "component", "Ljavax/swing/JComponent;", "<init>", "(Ljavax/swing/JComponent;)V", "uiOptions", "Lcom/intellij/profiler/ThreadListOptions;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "correspondingThreadList", "Lcom/intellij/profiler/ui/threadview/ThreadList;", "getCorrespondingThreadList", "()Lcom/intellij/profiler/ui/threadview/ThreadList;", "correspondingThreadList$delegate", "Lkotlin/Lazy;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "findCorrespondingThreadList", "intellij.profiler.common"})
public final class ToggleThreadListAction
extends DumbAwareAction {
    @NotNull
    private final JComponent component;
    @NotNull
    private final ThreadListOptions uiOptions;
    @NotNull
    private final Lazy correspondingThreadList$delegate;

    public ToggleThreadListAction(@NotNull JComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        this.component = component;
        this.uiOptions = ((CommonProfilerUiOptions)CommonProfilerUISettings.Companion.getInstance().getState()).getThreadListOptions();
        this.correspondingThreadList$delegate = LazyKt.lazy(() -> ToggleThreadListAction.correspondingThreadList_delegate$lambda$0(this));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    private final ThreadList getCorrespondingThreadList() {
        Lazy lazy = this.correspondingThreadList$delegate;
        return (ThreadList)((Object)lazy.getValue());
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (this.uiOptions.getShow()) {
            e.getPresentation().setIcon(AllIcons.General.ChevronLeft);
            e.getPresentation().setText(CommonProfilerBundleKt.commonProfilerMessage("ui.threadlist.hide", new Object[0]));
        } else {
            e.getPresentation().setIcon(AllIcons.General.ChevronRight);
            e.getPresentation().setText(CommonProfilerBundleKt.commonProfilerMessage("ui.threadlist.show", new Object[0]));
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        boolean isVisibleBeforeAction = this.getCorrespondingThreadList().isVisible();
        ProfilerUsageTriggerCollector.INSTANCE.logSnapshotInteraction(ProfilerUsageTriggerCollector.SnapshotActionFusDescriptor.THREAD_LIST_SHOW, e, !isVisibleBeforeAction);
        this.getCorrespondingThreadList().setVisible(!isVisibleBeforeAction);
    }

    private final ThreadList findCorrespondingThreadList() {
        JComponent current = this.component;
        while (current != null) {
            OnePixelSplitter splitter = (OnePixelSplitter)ComponentUtil.getParentOfType(OnePixelSplitter.class, (Component)this.component);
            Object object = splitter;
            if (object != null && (object = object.getFirstComponent()) != null) {
                Object it = object;
                boolean bl = false;
                List list = ComponentUtil.findComponentsOfType((JComponent)it, ThreadList.class);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findComponentsOfType(...)");
                ThreadList maybeThreadList = (ThreadList)((Object)CollectionsKt.firstOrNull((List)list));
                if (maybeThreadList != null) {
                    return maybeThreadList;
                }
            }
            current = (JComponent)splitter;
        }
        throw new IllegalStateException("Couldn't find ThreadList for the corresponding flame graph");
    }

    private static final ThreadList correspondingThreadList_delegate$lambda$0(ToggleThreadListAction this$0) {
        return this$0.findCorrespondingThreadList();
    }
}

