/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.utils.net;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.function.Supplier;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;

public class HostNameUtil {
    private static final Log log = LogManager.getLog(HostNameUtil.class);

    public static String getLocalHostAddress() throws UnknownHostException {
        String hostAddress = HostNameUtil.getLocalHostLANAddress().getHostAddress();
        log.debug("hostAddress = [{0}]", hostAddress);
        return hostAddress;
    }

    public static InetAddress getLocalHostLANAddress() throws UnknownHostException {
        return HostNameUtil.getLocalHostLANAddresses().stream().findFirst().orElse(null);
    }

    public static List<InetAddress> getLocalHostLANAddresses() throws UnknownHostException {
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        try {
            InetAddress candidateAddress = null;
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                if (iface.isLoopback() || !iface.isUp()) continue;
                Enumeration<InetAddress> inetAddrs = iface.getInetAddresses();
                while (inetAddrs.hasMoreElements()) {
                    InetAddress inetAddr = inetAddrs.nextElement();
                    if (inetAddr.isLoopbackAddress()) continue;
                    if (inetAddr.isSiteLocalAddress()) {
                        addresses.add(inetAddr);
                    }
                    if (candidateAddress != null) continue;
                    candidateAddress = inetAddr;
                }
            }
            if (candidateAddress != null && addresses.isEmpty()) {
                addresses.add(candidateAddress);
            }
            if (addresses.isEmpty()) {
                InetAddress jdkSuppliedAddress = InetAddress.getLocalHost();
                if (jdkSuppliedAddress == null) {
                    throw new UnknownHostException("The JDK InetAddress.getLocalHost() method unexpectedly returned null.");
                }
                addresses.add(jdkSuppliedAddress);
            }
        }
        catch (SocketException e) {
            UnknownHostException unknownHostException = new UnknownHostException("Failed to determine LAN address: " + e);
            unknownHostException.initCause(e);
            throw unknownHostException;
        }
        return addresses;
    }

    public static NetworkInterface getMulticastNetworkInterface() throws SocketException {
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface networkInterface = networkInterfaces.nextElement();
            if (!networkInterface.supportsMulticast()) {
                Supplier[] supplierArray = new Supplier[1];
                supplierArray[0] = networkInterface::getDisplayName;
                log.trace("found network interface [{0}]: no multicast support", supplierArray);
                continue;
            }
            Enumeration<InetAddress> addressesFromNetworkInterface = networkInterface.getInetAddresses();
            while (addressesFromNetworkInterface.hasMoreElements()) {
                InetAddress inetAddress = addressesFromNetworkInterface.nextElement();
                Supplier[] supplierArray = new Supplier[7];
                supplierArray[0] = networkInterface::getDisplayName;
                supplierArray[1] = inetAddress::getHostAddress;
                supplierArray[2] = inetAddress::isSiteLocalAddress;
                supplierArray[3] = inetAddress::isAnyLocalAddress;
                supplierArray[4] = inetAddress::isLinkLocalAddress;
                supplierArray[5] = inetAddress::isLoopbackAddress;
                supplierArray[6] = inetAddress::isMulticastAddress;
                log.trace("found network interface [{0}]: address: {1}, site local: {2}, any local {3}, link local {4}, loopback {5}, multicast {6}", supplierArray);
                if (!inetAddress.isSiteLocalAddress() || inetAddress.isAnyLocalAddress() || inetAddress.isLinkLocalAddress() || inetAddress.isLoopbackAddress() || inetAddress.isMulticastAddress()) continue;
                return networkInterface;
            }
        }
        return null;
    }
}

