/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.lists.Consumer;
import gnu.lists.TreeList;
import gnu.mapping.CallContext;
import gnu.mapping.Values;

class ValueStack
extends TreeList {
    int gapStartOnPush;
    Consumer consumerOnPush = this;
    int oindexOnPush;
    Object lastObject = this;

    ValueStack() {
    }

    @Override
    public void clear() {
        super.clear();
        this.lastObject = this;
    }

    void push() {
        if (this.lastObject != this) {
            super.writeObject(this.lastObject);
            this.lastObject = this;
        }
        int oindex = this.find(this.consumerOnPush);
        this.writeIntForce32(oindex);
        this.writeIntForce32(this.gapStartOnPush);
    }

    void pop(int saved) {
        this.gapStartOnPush = this.getIntN(saved - 2);
        int oindex = this.getIntN(saved - 5);
        this.consumerOnPush = (Consumer)this.objects[oindex];
        this.objects[oindex] = null;
        this.oindexOnPush = oindex;
        this.gapStart = saved - 6;
    }

    public void pushArgState(CallContext ctx) {
        int saveGap = this.gapStart;
        this.writeIntForce32(ctx.consumerOnPushArgState);
        this.writeIntForce32(ctx.next);
        this.writeIntForce32(ctx.count);
        this.writeIntForce32(ctx.firstKeyword);
        this.writeIntForce32(ctx.numKeywords);
        this.writeIntForce32(ctx.nextKeyword);
        this.writeIntForce32(ctx.matchState);
        ctx.consumerOnPushArgState = saveGap;
        int ogrow = ctx.count + 2;
        this.reserveObjects(ogrow);
        System.arraycopy(ctx.values, 0, this.objects, this.oindex, ctx.count);
        this.objects[this.oindex + ctx.count] = ctx.keywords;
        this.objects[this.oindex + ctx.count + 1] = ctx.sortedKeywords;
        this.oindex += ogrow;
        ctx.next = 0;
        ctx.count = 0;
        ctx.firstKeyword = 0;
        ctx.numKeywords = 0;
        ctx.nextKeyword = 0;
        ctx.matchState = 0;
        ctx.keywords = null;
        ctx.sortedKeywords = null;
    }

    public void popArgState(CallContext ctx) {
        int start = ctx.consumerOnPushArgState;
        ctx.consumerOnPushArgState = this.getIntN(start + 1);
        ctx.next = this.getIntN(start + 4);
        ctx.count = this.getIntN(start + 7);
        ctx.firstKeyword = this.getIntN(start + 10);
        ctx.numKeywords = this.getIntN(start + 13);
        ctx.nextKeyword = this.getIntN(start + 16);
        ctx.matchState = this.getIntN(start + 19);
        this.gapStart = start;
        int ogrow = ctx.count + 2;
        this.oindex -= ogrow;
        System.arraycopy(this.objects, this.oindex, ctx.values, 0, ctx.count);
        ctx.keywords = (String[])this.objects[this.oindex + ctx.count];
        ctx.sortedKeywords = (short[])this.objects[this.oindex + ctx.count + 1];
        for (int i = 0; i < ogrow; ++i) {
            this.objects[this.oindex + 1] = null;
        }
    }

    Object getValue() {
        Object last = this.lastObject;
        if (this.gapStart == this.gapStartOnPush) {
            return last == this ? Values.empty : last;
        }
        int next = this.nextDataIndex(this.gapStartOnPush);
        if (next == this.gapStart && last == this) {
            return this.getPosNext(this.gapStartOnPush << 1);
        }
        Values.FromTreeList vals = new Values.FromTreeList();
        super.consumeIRange(this.gapStartOnPush, this.gapStart, vals);
        if (this.lastObject != this) {
            vals.writeObject(this.lastObject);
        }
        return vals;
    }

    @Override
    public void ensureSpace(int needed) {
        super.ensureSpace(needed + 3);
        if (this.lastObject != this) {
            super.writeObject(this.lastObject);
            this.lastObject = this;
        }
    }

    @Override
    public void writeObject(Object v) {
        if (this.lastObject != this) {
            super.writeObject(this.lastObject);
        }
        this.lastObject = v;
    }
}

