/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.logging;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.MDC;
import org.keycloak.Config;
import org.keycloak.common.Profile;
import org.keycloak.logging.MappedDiagnosticContextProvider;
import org.keycloak.logging.MappedDiagnosticContextProviderFactory;
import org.keycloak.logging.MappedDiagnosticContextUtil;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.OrganizationModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.sessions.AuthenticationSessionModel;

public class DefaultMappedDiagnosticContextProviderFactory
implements MappedDiagnosticContextProviderFactory,
MappedDiagnosticContextProvider,
EnvironmentDependentProviderFactory {
    public static final String MDC_KEY_REALM_NAME = "kc.realmName";
    public static final String MDC_KEY_CLIENT_ID = "kc.clientId";
    public static final String MDC_KEY_USER_ID = "kc.userId";
    public static final String MDC_KEY_IP_ADDRESS = "kc.ipAddress";
    public static final String MDC_KEY_ORGANIZATION = "kc.org";
    public static final String MDC_KEY_SESSION_ID = "kc.sessionId";
    public static final String MDC_KEY_AUTHENTICATION_SESSION_ID = "kc.authenticationSessionId";
    public static final String MDC_KEY_AUTHENTICATION_TAB_ID = "kc.authenticationTabId";
    public static final String MDC_KEYS = "mdcKeys";
    private Set<String> mdcKeys;

    public MappedDiagnosticContextProvider create(KeycloakSession session) {
        return this;
    }

    public void init(Config.Scope config) {
        this.mdcKeys = Arrays.stream(Objects.requireNonNullElse(config.getArray(MDC_KEYS), new String[0])).map(s -> "kc." + s).collect(Collectors.toSet());
        MappedDiagnosticContextUtil.setKeysToClear(this.mdcKeys);
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return "default";
    }

    public List<ProviderConfigProperty> getConfigMetadata() {
        ProviderConfigurationBuilder builder = ProviderConfigurationBuilder.create();
        builder.property().name(MDC_KEYS).type("string").helpText("Comma-separated list of MDC keys to add to the Mapped Diagnostic Context.").options(Stream.of(MDC_KEY_REALM_NAME, MDC_KEY_CLIENT_ID, MDC_KEY_USER_ID, MDC_KEY_IP_ADDRESS, MDC_KEY_ORGANIZATION, MDC_KEY_SESSION_ID, MDC_KEY_AUTHENTICATION_SESSION_ID, MDC_KEY_AUTHENTICATION_TAB_ID).map(s -> s.substring("kc.".length())).collect(Collectors.toList())).add();
        return builder.build();
    }

    public boolean isSupported(Config.Scope config) {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.LOG_MDC);
    }

    public void update(KeycloakContext keycloakContext, AuthenticationSessionModel session) {
        if (this.mdcKeys.contains(MDC_KEY_AUTHENTICATION_SESSION_ID)) {
            this.putMdc(MDC_KEY_AUTHENTICATION_SESSION_ID, session != null ? (session.getParentSession() != null ? session.getParentSession().getId() : null) : null);
        }
        if (this.mdcKeys.contains(MDC_KEY_AUTHENTICATION_TAB_ID)) {
            this.putMdc(MDC_KEY_AUTHENTICATION_TAB_ID, session != null ? session.getTabId() : null);
        }
    }

    public void update(KeycloakContext keycloakContext, RealmModel realm) {
        if (this.mdcKeys.contains(MDC_KEY_REALM_NAME)) {
            this.putMdc(MDC_KEY_REALM_NAME, realm != null ? realm.getName() : null);
        }
    }

    public void update(KeycloakContext keycloakContext, ClientModel client) {
        if (this.mdcKeys.contains(MDC_KEY_CLIENT_ID)) {
            this.putMdc(MDC_KEY_CLIENT_ID, client != null ? client.getClientId() : null);
        }
    }

    public void update(KeycloakContext keycloakContext, OrganizationModel organization) {
        if (this.mdcKeys.contains(MDC_KEY_ORGANIZATION)) {
            this.putMdc(MDC_KEY_ORGANIZATION, organization != null ? organization.getAlias() : null);
        }
    }

    public void update(KeycloakContext keycloakContext, UserSessionModel userSession) {
        if (this.mdcKeys.contains(MDC_KEY_USER_ID)) {
            this.putMdc(MDC_KEY_USER_ID, userSession != null && userSession.getUser() != null ? userSession.getUser().getId() : null);
        }
        if (this.mdcKeys.contains(MDC_KEY_SESSION_ID)) {
            this.putMdc(MDC_KEY_SESSION_ID, userSession != null ? userSession.getId() : null);
        }
        if (this.mdcKeys.contains(MDC_KEY_IP_ADDRESS)) {
            this.putMdc(MDC_KEY_IP_ADDRESS, userSession != null ? userSession.getIpAddress() : null);
        }
    }

    protected void putMdc(String key, String value) {
        if (value != null) {
            MDC.put((String)key, (Object)value);
        } else {
            MDC.remove((String)key);
        }
    }
}

