/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.parameters;

import io.smallrye.openapi.model.Extensions;
import io.smallrye.openapi.model.ReferenceType;
import io.smallrye.openapi.runtime.io.IOContext;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.MapModelIO;
import io.smallrye.openapi.runtime.io.Names;
import io.smallrye.openapi.runtime.io.ReferenceIO;
import io.smallrye.openapi.runtime.io.media.ContentIO;
import io.smallrye.openapi.runtime.io.schema.SchemaFactory;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.MediaType;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class RequestBodyIO<V, A extends V, O extends V, AB, OB>
extends MapModelIO<RequestBody, V, A, O, AB, OB>
implements ReferenceIO<V, A, O, AB, OB> {
    private static final String PROP_REQUIRED = "required";
    private static final String PROP_DESCRIPTION = "description";
    private static final String PROP_CONTENT = "content";
    private static final String PROP_VALUE = "value";

    public RequestBodyIO(IOContext<V, A, O, AB, OB> context) {
        super(context, Names.REQUEST_BODY, Names.create(RequestBody.class));
    }

    Stream<AnnotationInstance> getAnnotations(MethodInfo method, DotName annotation) {
        Stream<AnnotationInstance> methodAnnos = Stream.of(this.scannerContext().annotations().getAnnotation((AnnotationTarget)method, annotation));
        Stream<AnnotationInstance> paramAnnos = IntStream.range(0, method.parametersCount()).mapToObj(p -> this.scannerContext().annotations().getMethodParameterAnnotation(method, p, annotation));
        return Stream.concat(methodAnnos, paramAnnos).filter(Objects::nonNull);
    }

    @Override
    public List<AnnotationInstance> getRepeatableAnnotations(AnnotationTarget target) {
        if (target.kind() == AnnotationTarget.Kind.METHOD) {
            return this.getAnnotations(target.asMethod(), Names.REQUEST_BODY).collect(Collectors.toList());
        }
        return Collections.singletonList(this.scannerContext().annotations().getAnnotation(target, Names.REQUEST_BODY));
    }

    @Override
    public RequestBody read(AnnotationInstance annotation) {
        IoLogging.logger.singleAnnotation("@RequestBody");
        RequestBody requestBody = OASFactory.createRequestBody();
        requestBody.setDescription((String)this.value(annotation, PROP_DESCRIPTION));
        requestBody.setContent(this.contentIO().read(annotation.value(PROP_CONTENT), ContentIO.Direction.INPUT));
        requestBody.setRef(ReferenceType.REQUEST_BODY.refValue(annotation));
        requestBody.setExtensions(this.extensionIO().readExtensible(annotation));
        Boolean required = (Boolean)this.value(annotation, PROP_REQUIRED);
        if (required != null) {
            requestBody.setRequired(required);
        } else {
            Extensions.setRequiredDefault((RequestBody)requestBody, (Boolean)Boolean.TRUE);
        }
        return requestBody;
    }

    public RequestBody readRequestSchema(MethodInfo target) {
        if (this.scannerContext().getCurrentConsumes() == null) {
            return null;
        }
        return this.getAnnotations(target, Names.REQUEST_BODY_SCHEMA).map(this::readRequestSchema).findFirst().orElse(null);
    }

    private RequestBody readRequestSchema(AnnotationInstance annotation) {
        IoLogging.logger.singleAnnotation("@RequestBodySchema");
        Content content = OASFactory.createContent();
        for (String mediaType : this.scannerContext().getCurrentConsumes()) {
            MediaType type = OASFactory.createMediaType();
            type.setSchema(SchemaFactory.typeToSchema(this.scannerContext(), (Type)this.value(annotation, PROP_VALUE), null));
            content.addMediaType(mediaType, type);
        }
        return OASFactory.createRequestBody().content(content);
    }
}

