/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.model.events;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.Filter;
import org.ops4j.pax.web.service.spi.model.elements.FilterModel;
import org.ops4j.pax.web.service.spi.model.events.WebElementEventData;

public class FilterEventData
extends WebElementEventData {
    private final String filterName;
    private String[] urlPatterns;
    private String[] servletNames;
    private String[] regexMapping;
    private String[] dispatcherTypes;
    private final Filter filter;
    private final Class<? extends Filter> filterClass;

    public FilterEventData(String filterName, List<FilterModel.Mapping> mapping, Filter filter, Class<? extends Filter> filterClass) {
        this.filterName = filterName;
        ArrayList urlPatterns = new ArrayList();
        ArrayList servletNames = new ArrayList();
        ArrayList regexMapping = new ArrayList();
        for (FilterModel.Mapping m : mapping) {
            String[] rm;
            String[] sn;
            String[] up = m.getUrlPatterns();
            if (up != null) {
                this.urlPatterns = Arrays.copyOf(up, up.length);
            }
            if ((sn = m.getServletNames()) != null) {
                this.servletNames = Arrays.copyOf(sn, sn.length);
            }
            if ((rm = m.getRegexPatterns()) == null) continue;
            this.regexMapping = Arrays.copyOf(rm, rm.length);
        }
        this.filter = filter;
        this.filterClass = filterClass;
    }

    public String getFilterName() {
        return this.filterName;
    }

    public String[] getUrlPatterns() {
        return this.urlPatterns;
    }

    public String[] getServletNames() {
        return this.servletNames;
    }

    public String[] getRegexMapping() {
        return this.regexMapping;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public Class<? extends Filter> getFilterClass() {
        return this.filterClass;
    }
}

