/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.correlation.alert;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.commons.alerting.model.Alert;
import org.opensearch.commons.alerting.model.CorrelationAlert;
import org.opensearch.commons.alerting.model.action.Action;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.securityanalytics.correlation.alert.CorrelationAlertService;
import org.opensearch.securityanalytics.correlation.alert.CorrelationAlertsList;
import org.opensearch.securityanalytics.correlation.alert.notifications.CorrelationAlertContext;
import org.opensearch.securityanalytics.correlation.alert.notifications.NotificationService;
import org.opensearch.securityanalytics.model.CorrelationQuery;
import org.opensearch.securityanalytics.model.CorrelationRule;
import org.opensearch.securityanalytics.model.CorrelationRuleTrigger;
import org.opensearch.securityanalytics.util.SecurityAnalyticsException;
import org.opensearch.transport.client.Client;

public class CorrelationRuleScheduler {
    private final Logger log = LogManager.getLogger(CorrelationRuleScheduler.class);
    private final Client client;
    private final CorrelationAlertService correlationAlertService;
    private final NotificationService notificationService;

    public CorrelationRuleScheduler(Client client, CorrelationAlertService correlationAlertService, NotificationService notificationService) {
        this.client = client;
        this.correlationAlertService = correlationAlertService;
        this.notificationService = notificationService;
    }

    public void schedule(List<CorrelationRule> correlationRules, Map<String, List<String>> correlatedFindings, String sourceFinding, TimeValue indexTimeout, User user) {
        for (CorrelationRule rule : correlationRules) {
            CorrelationRuleTrigger trigger = rule.getCorrelationTrigger();
            if (trigger == null) continue;
            ArrayList<String> findingIds = new ArrayList<String>();
            for (CorrelationQuery query : rule.getCorrelationQueries()) {
                List<String> categoryFindingIds = correlatedFindings.get(query.getCategory());
                if (categoryFindingIds == null) continue;
                findingIds.addAll(categoryFindingIds);
            }
            this.scheduleRule(rule, findingIds, indexTimeout, sourceFinding, user);
        }
    }

    private void scheduleRule(CorrelationRule correlationRule, List<String> findingIds, TimeValue indexTimeout, String sourceFindingId, User user) {
        long startTime = Instant.now().toEpochMilli();
        long endTime = startTime + correlationRule.getCorrTimeWindow();
        RuleTask ruleTask = new RuleTask(correlationRule, findingIds, startTime, endTime, this.correlationAlertService, this.notificationService, indexTimeout, sourceFindingId, user);
        ruleTask.run();
    }

    private class RuleTask
    implements Runnable {
        private final CorrelationRule correlationRule;
        private final long startTime;
        private final long endTime;
        private final List<String> correlatedFindingIds;
        private final CorrelationAlertService correlationAlertService;
        private final NotificationService notificationService;
        private final TimeValue indexTimeout;
        private final String sourceFindingId;
        private final User user;

        public RuleTask(CorrelationRule correlationRule, List<String> correlatedFindingIds, long startTime, long endTime, CorrelationAlertService correlationAlertService, NotificationService notificationService, TimeValue indexTimeout, String sourceFindingId, User user) {
            this.correlationRule = correlationRule;
            this.correlatedFindingIds = correlatedFindingIds;
            this.startTime = startTime;
            this.endTime = endTime;
            this.correlationAlertService = correlationAlertService;
            this.notificationService = notificationService;
            this.indexTimeout = indexTimeout;
            this.sourceFindingId = sourceFindingId;
            this.user = user;
        }

        @Override
        public void run() {
            long currentTime = Instant.now().toEpochMilli();
            if (currentTime >= this.startTime && currentTime <= this.endTime) {
                try {
                    this.correlationAlertService.getActiveAlerts(this.correlationRule.getId(), currentTime, new ActionListener<CorrelationAlertsList>(){

                        public void onResponse(CorrelationAlertsList correlationAlertsList) {
                            if (correlationAlertsList.getTotalAlerts() == 0) {
                                RuleTask.this.addCorrelationAlertIntoIndex();
                                List<Action> actions = RuleTask.this.correlationRule.getCorrelationTrigger().getActions();
                                for (Action action : actions) {
                                    String configId = action.getDestinationId();
                                    CorrelationAlertContext ctx = new CorrelationAlertContext(RuleTask.this.correlatedFindingIds, RuleTask.this.correlationRule.getName(), RuleTask.this.correlationRule.getCorrTimeWindow(), RuleTask.this.sourceFindingId);
                                    NotificationService cfr_ignored_0 = RuleTask.this.notificationService;
                                    String transformedSubject = NotificationService.compileTemplate(ctx, action.getSubjectTemplate());
                                    NotificationService cfr_ignored_1 = RuleTask.this.notificationService;
                                    String transformedMessage = NotificationService.compileTemplate(ctx, action.getMessageTemplate());
                                    try {
                                        RuleTask.this.notificationService.sendNotification(configId, RuleTask.this.correlationRule.getCorrelationTrigger().getSeverity(), transformedSubject, transformedMessage);
                                    }
                                    catch (Exception e) {
                                        CorrelationRuleScheduler.this.log.error("Failed while sending a notification with " + configId + "for correlationRule id " + RuleTask.this.correlationRule.getId(), (Throwable)e);
                                        new SecurityAnalyticsException("Failed to send notification", RestStatus.INTERNAL_SERVER_ERROR, e);
                                    }
                                }
                            } else {
                                for (CorrelationAlert correlationAlert : correlationAlertsList.getCorrelationAlertList()) {
                                    RuleTask.this.updateCorrelationAlert(correlationAlert);
                                }
                            }
                        }

                        public void onFailure(Exception e) {
                            CorrelationRuleScheduler.this.log.error("Failed to search active correlation alert", (Throwable)e);
                            new SecurityAnalyticsException("Failed to search active correlation alert", RestStatus.INTERNAL_SERVER_ERROR, e);
                        }
                    });
                }
                catch (Exception e) {
                    CorrelationRuleScheduler.this.log.error("Failed to fetch active alerts in the time window", (Throwable)e);
                    new SecurityAnalyticsException("Failed to get active alerts in the correlationRuletimewindow", RestStatus.INTERNAL_SERVER_ERROR, e);
                }
            }
        }

        private void addCorrelationAlertIntoIndex() {
            CorrelationAlert correlationAlert = new CorrelationAlert(this.correlatedFindingIds, this.correlationRule.getId(), this.correlationRule.getName(), UUID.randomUUID().toString(), 1L, 1, this.user, this.correlationRule.getCorrelationTrigger().getName(), Alert.State.ACTIVE, Instant.ofEpochMilli(this.startTime), Instant.ofEpochMilli(this.endTime), null, null, this.correlationRule.getCorrelationTrigger().getSeverity(), new ArrayList());
            this.insertCorrelationAlert(correlationAlert);
        }

        private void updateCorrelationAlert(CorrelationAlert correlationAlert) {
            CorrelationAlert newCorrelationAlert = new CorrelationAlert(this.correlatedFindingIds, correlationAlert.getCorrelationRuleId(), correlationAlert.getCorrelationRuleName(), correlationAlert.getId(), 1L, 1, correlationAlert.getUser(), this.correlationRule.getCorrelationTrigger().getName(), Alert.State.ACTIVE, Instant.ofEpochMilli(this.startTime), Instant.ofEpochMilli(this.endTime), null, null, this.correlationRule.getCorrelationTrigger().getSeverity(), new ArrayList());
            this.insertCorrelationAlert(newCorrelationAlert);
        }

        private void insertCorrelationAlert(CorrelationAlert correlationAlert) {
            this.correlationAlertService.indexCorrelationAlert(correlationAlert, this.indexTimeout, new ActionListener<IndexResponse>(){

                public void onResponse(IndexResponse indexResponse) {
                    CorrelationRuleScheduler.this.log.info("Successfully updated the index .opensearch-sap-correlation-alerts: {}", (Object)indexResponse);
                }

                public void onFailure(Exception e) {
                    CorrelationRuleScheduler.this.log.error("Failed to index correlation alert", (Throwable)e);
                }
            });
        }
    }
}

