/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.threatIntel.action;

import java.io.IOException;
import java.time.Instant;
import java.util.List;
import java.util.Locale;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.commons.alerting.model.Table;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;

public class GetIocFindingsRequest
extends ActionRequest {
    private List<String> findingIds;
    private List<String> iocIds;
    private Instant startTime;
    private Instant endTime;
    private Table table;

    public GetIocFindingsRequest(StreamInput sin) throws IOException {
        this(sin.readOptionalStringList(), sin.readOptionalStringList(), sin.readOptionalInstant(), sin.readOptionalInstant(), Table.readFrom((StreamInput)sin));
    }

    public GetIocFindingsRequest(List<String> findingIds, List<String> iocIds, Instant startTime, Instant endTime, Table table) {
        this.findingIds = findingIds;
        this.iocIds = iocIds;
        this.startTime = startTime;
        this.endTime = endTime;
        this.table = table;
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.startTime != null && this.endTime != null && this.startTime.isAfter(this.endTime)) {
            validationException = ValidateActions.addValidationError((String)String.format(Locale.getDefault(), "startTime should be less than endTime", new Object[0]), validationException);
        }
        return validationException;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalStringCollection(this.findingIds);
        out.writeOptionalStringCollection(this.iocIds);
        out.writeOptionalInstant(this.startTime);
        out.writeOptionalInstant(this.endTime);
        this.table.writeTo(out);
    }

    public List<String> getFindingIds() {
        return this.findingIds;
    }

    public List<String> getIocIds() {
        return this.iocIds;
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public Instant getEndTime() {
        return this.endTime;
    }

    public Table getTable() {
        return this.table;
    }
}

