/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.util;

import java.io.Serializable;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.types.DateUnit;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.IntervalUnit;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.spark.sql.errors.ExecutionErrors$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$Fixed$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;

public final class ArrowUtils$ {
    public static final ArrowUtils$ MODULE$ = new ArrowUtils$();
    private static final RootAllocator rootAllocator = new RootAllocator(Long.MAX_VALUE);

    public RootAllocator rootAllocator() {
        return rootAllocator;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ArrowType toArrowType(DataType dt, String timeZoneId, boolean largeVarTypes) {
        DecimalType decimalType;
        Option<Tuple2<Object, Object>> option;
        boolean bl = false;
        DataType dataType = null;
        boolean bl2 = false;
        DataType dataType2 = null;
        boolean bl3 = false;
        DataType dataType3 = null;
        DataType dataType4 = dt;
        if (BooleanType$.MODULE$.equals(dataType4)) {
            return ArrowType.Bool.INSTANCE;
        }
        if (ByteType$.MODULE$.equals(dataType4)) {
            return new ArrowType.Int(8, true);
        }
        if (ShortType$.MODULE$.equals(dataType4)) {
            return new ArrowType.Int(16, true);
        }
        if (IntegerType$.MODULE$.equals(dataType4)) {
            return new ArrowType.Int(32, true);
        }
        if (LongType$.MODULE$.equals(dataType4)) {
            return new ArrowType.Int(64, true);
        }
        if (FloatType$.MODULE$.equals(dataType4)) {
            return new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE);
        }
        if (DoubleType$.MODULE$.equals(dataType4)) {
            return new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE);
        }
        if (StringType$.MODULE$.equals(dataType4)) {
            bl = true;
            dataType = dataType4;
            if (!largeVarTypes) {
                return ArrowType.Utf8.INSTANCE;
            }
        }
        if (BinaryType$.MODULE$.equals(dataType4)) {
            bl2 = true;
            dataType2 = dataType4;
            if (!largeVarTypes) {
                return ArrowType.Binary.INSTANCE;
            }
        }
        if (bl && largeVarTypes) {
            return ArrowType.LargeUtf8.INSTANCE;
        }
        if (bl2 && largeVarTypes) {
            return ArrowType.LargeBinary.INSTANCE;
        }
        if (dataType4 instanceof DecimalType && !(option = DecimalType$Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType4)).isEmpty()) {
            int precision = ((Tuple2)option.get())._1$mcI$sp();
            int scale = ((Tuple2)option.get())._2$mcI$sp();
            return new ArrowType.Decimal(precision, scale);
        }
        if (DateType$.MODULE$.equals(dataType4)) {
            return new ArrowType.Date(DateUnit.DAY);
        }
        if (TimestampType$.MODULE$.equals(dataType4)) {
            bl3 = true;
            dataType3 = dataType4;
            if (timeZoneId == null) {
                throw new IllegalStateException("Missing timezoneId where it is mandatory.");
            }
        }
        if (bl3) {
            return new ArrowType.Timestamp(TimeUnit.MICROSECOND, timeZoneId);
        }
        if (TimestampNTZType$.MODULE$.equals(dataType4)) {
            return new ArrowType.Timestamp(TimeUnit.MICROSECOND, null);
        }
        if (NullType$.MODULE$.equals(dataType4)) {
            return ArrowType.Null.INSTANCE;
        }
        if (dataType4 instanceof YearMonthIntervalType) {
            return new ArrowType.Interval(IntervalUnit.YEAR_MONTH);
        }
        if (!(dataType4 instanceof DayTimeIntervalType)) throw ExecutionErrors$.MODULE$.unsupportedDataTypeError(dt);
        return new ArrowType.Duration(TimeUnit.MICROSECOND);
    }

    public boolean toArrowType$default$3() {
        return false;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public DataType fromArrowType(ArrowType dt) {
        void var2_28;
        boolean bl = false;
        ArrowType.Int intVal = null;
        boolean bl2 = false;
        ArrowType.FloatingPoint floatingPoint = null;
        boolean bl3 = false;
        ArrowType.Timestamp timestamp = null;
        ArrowType arrowType = dt;
        ArrowType.Bool bool = ArrowType.Bool.INSTANCE;
        ArrowType arrowType2 = arrowType;
        if (!(bool != null ? !bool.equals(arrowType2) : arrowType2 != null)) {
            BooleanType$ booleanType$ = BooleanType$.MODULE$;
            return var2_28;
        }
        if (arrowType instanceof ArrowType.Int) {
            bl = true;
            intVal = (ArrowType.Int)arrowType;
            if (intVal.getIsSigned() && intVal.getBitWidth() == 8) {
                ByteType$ byteType$ = ByteType$.MODULE$;
                return var2_28;
            }
        }
        if (bl && intVal.getIsSigned() && intVal.getBitWidth() == 16) {
            ShortType$ shortType$ = ShortType$.MODULE$;
            return var2_28;
        }
        if (bl && intVal.getIsSigned() && intVal.getBitWidth() == 32) {
            IntegerType$ integerType$ = IntegerType$.MODULE$;
            return var2_28;
        }
        if (bl && intVal.getIsSigned() && intVal.getBitWidth() == 64) {
            LongType$ longType$ = LongType$.MODULE$;
            return var2_28;
        }
        if (arrowType instanceof ArrowType.FloatingPoint) {
            bl2 = true;
            floatingPoint = (ArrowType.FloatingPoint)arrowType;
            FloatingPointPrecision floatingPointPrecision = floatingPoint.getPrecision();
            FloatingPointPrecision floatingPointPrecision2 = FloatingPointPrecision.SINGLE;
            if (!(floatingPointPrecision != null ? !floatingPointPrecision.equals(floatingPointPrecision2) : floatingPointPrecision2 != null)) {
                FloatType$ floatType$ = FloatType$.MODULE$;
                return var2_28;
            }
        }
        if (bl2) {
            FloatingPointPrecision floatingPointPrecision = floatingPoint.getPrecision();
            FloatingPointPrecision floatingPointPrecision3 = FloatingPointPrecision.DOUBLE;
            if (!(floatingPointPrecision != null ? !floatingPointPrecision.equals(floatingPointPrecision3) : floatingPointPrecision3 != null)) {
                DoubleType$ doubleType$ = DoubleType$.MODULE$;
                return var2_28;
            }
        }
        ArrowType.Utf8 utf8 = ArrowType.Utf8.INSTANCE;
        ArrowType arrowType3 = arrowType;
        if (!(utf8 != null ? !utf8.equals(arrowType3) : arrowType3 != null)) {
            StringType$ stringType$ = StringType$.MODULE$;
            return var2_28;
        }
        ArrowType.Binary binary = ArrowType.Binary.INSTANCE;
        ArrowType arrowType4 = arrowType;
        if (!(binary != null ? !binary.equals(arrowType4) : arrowType4 != null)) {
            BinaryType$ binaryType$ = BinaryType$.MODULE$;
            return var2_28;
        }
        ArrowType.LargeUtf8 largeUtf8 = ArrowType.LargeUtf8.INSTANCE;
        ArrowType arrowType5 = arrowType;
        if (!(largeUtf8 != null ? !largeUtf8.equals(arrowType5) : arrowType5 != null)) {
            StringType$ stringType$ = StringType$.MODULE$;
            return var2_28;
        }
        ArrowType.LargeBinary largeBinary = ArrowType.LargeBinary.INSTANCE;
        ArrowType arrowType6 = arrowType;
        if (!(largeBinary != null ? !largeBinary.equals(arrowType6) : arrowType6 != null)) {
            BinaryType$ binaryType$ = BinaryType$.MODULE$;
            return var2_28;
        }
        if (arrowType instanceof ArrowType.Decimal) {
            ArrowType.Decimal decimal = (ArrowType.Decimal)arrowType;
            DecimalType decimalType = new DecimalType(decimal.getPrecision(), decimal.getScale());
            return var2_28;
        }
        if (arrowType instanceof ArrowType.Date) {
            ArrowType.Date date = (ArrowType.Date)arrowType;
            DateUnit dateUnit = date.getUnit();
            DateUnit dateUnit2 = DateUnit.DAY;
            if (!(dateUnit != null ? !dateUnit.equals(dateUnit2) : dateUnit2 != null)) {
                DateType$ dateType$ = DateType$.MODULE$;
                return var2_28;
            }
        }
        if (arrowType instanceof ArrowType.Timestamp) {
            bl3 = true;
            timestamp = (ArrowType.Timestamp)arrowType;
            TimeUnit timeUnit = timestamp.getUnit();
            TimeUnit timeUnit2 = TimeUnit.MICROSECOND;
            if (!(timeUnit != null ? !timeUnit.equals(timeUnit2) : timeUnit2 != null) && timestamp.getTimezone() == null) {
                TimestampNTZType$ timestampNTZType$ = TimestampNTZType$.MODULE$;
                return var2_28;
            }
        }
        if (bl3) {
            TimeUnit timeUnit = timestamp.getUnit();
            TimeUnit timeUnit3 = TimeUnit.MICROSECOND;
            if (!(timeUnit != null ? !timeUnit.equals(timeUnit3) : timeUnit3 != null)) {
                TimestampType$ timestampType$ = TimestampType$.MODULE$;
                return var2_28;
            }
        }
        ArrowType.Null nullVal = ArrowType.Null.INSTANCE;
        ArrowType arrowType7 = arrowType;
        if (!(nullVal != null ? !nullVal.equals(arrowType7) : arrowType7 != null)) {
            NullType$ nullType$ = NullType$.MODULE$;
            return var2_28;
        }
        if (arrowType instanceof ArrowType.Interval) {
            ArrowType.Interval interval = (ArrowType.Interval)arrowType;
            IntervalUnit intervalUnit = interval.getUnit();
            IntervalUnit intervalUnit2 = IntervalUnit.YEAR_MONTH;
            if (!(intervalUnit != null ? !intervalUnit.equals(intervalUnit2) : intervalUnit2 != null)) {
                YearMonthIntervalType yearMonthIntervalType = YearMonthIntervalType$.MODULE$.apply();
                return var2_28;
            }
        }
        if (!(arrowType instanceof ArrowType.Duration)) throw ExecutionErrors$.MODULE$.unsupportedArrowTypeError(dt);
        ArrowType.Duration duration = (ArrowType.Duration)arrowType;
        TimeUnit timeUnit = duration.getUnit();
        TimeUnit timeUnit4 = TimeUnit.MICROSECOND;
        if (timeUnit == null) {
            if (timeUnit4 != null) {
                throw ExecutionErrors$.MODULE$.unsupportedArrowTypeError(dt);
            }
        } else if (!timeUnit.equals(timeUnit4)) throw ExecutionErrors$.MODULE$.unsupportedArrowTypeError(dt);
        DayTimeIntervalType dayTimeIntervalType = DayTimeIntervalType$.MODULE$.apply();
        return var2_28;
    }

    public Field toArrowField(String name, DataType dt, boolean nullable, String timeZoneId, boolean largeVarTypes) {
        Field field2;
        block4: {
            DataType dataType;
            while (true) {
                if ((dataType = dt) instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    DataType elementType = arrayType.elementType();
                    boolean containsNull = arrayType.containsNull();
                    FieldType fieldType = new FieldType(nullable, (ArrowType)ArrowType.List.INSTANCE, null);
                    field2 = new Field(name, fieldType, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Field[]{this.toArrowField("element", elementType, containsNull, timeZoneId, largeVarTypes)}))).asJava());
                    break block4;
                }
                if (dataType instanceof StructType) {
                    StructType structType = (StructType)dataType;
                    StructField[] fields = structType.fields();
                    FieldType fieldType = new FieldType(nullable, (ArrowType)ArrowType.Struct.INSTANCE, null);
                    field2 = new Field(name, fieldType, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])fields), (Function1 & Serializable)field -> MODULE$.toArrowField(field.name(), field.dataType(), field.nullable(), timeZoneId, largeVarTypes), ClassTag$.MODULE$.apply(Field.class))))).asJava());
                    break block4;
                }
                if (dataType instanceof MapType) {
                    MapType mapType = (MapType)dataType;
                    DataType keyType = mapType.keyType();
                    DataType valueType = mapType.valueType();
                    boolean valueContainsNull = mapType.valueContainsNull();
                    FieldType mapType2 = new FieldType(nullable, (ArrowType)new ArrowType.Map(false), null);
                    field2 = new Field(name, mapType2, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Field[]{this.toArrowField("entries", new StructType().add("key", keyType, false).add("value", valueType, valueContainsNull), false, timeZoneId, largeVarTypes)}))).asJava());
                    break block4;
                }
                if (!(dataType instanceof UserDefinedType)) break;
                UserDefinedType userDefinedType = (UserDefinedType)dataType;
                dt = userDefinedType.sqlType();
            }
            FieldType fieldType = new FieldType(nullable, this.toArrowType(dataType, timeZoneId, largeVarTypes), null);
            field2 = new Field(name, fieldType, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)package$.MODULE$.Seq().empty()).asJava());
        }
        return field2;
    }

    public boolean toArrowField$default$5() {
        return false;
    }

    public DataType fromArrowField(Field field) {
        DataType dataType;
        ArrowType arrowType = field.getType();
        if (arrowType instanceof ArrowType.Map) {
            Field elementField = (Field)field.getChildren().get(0);
            DataType keyType = this.fromArrowField((Field)elementField.getChildren().get(0));
            DataType valueType = this.fromArrowField((Field)elementField.getChildren().get(1));
            dataType = new MapType(keyType, valueType, ((Field)elementField.getChildren().get(1)).isNullable());
        } else {
            ArrowType.List list = ArrowType.List.INSTANCE;
            ArrowType arrowType2 = arrowType;
            if (!(list != null ? !list.equals(arrowType2) : arrowType2 != null)) {
                Field elementField = (Field)field.getChildren().get(0);
                DataType elementType = this.fromArrowField(elementField);
                dataType = new ArrayType(elementType, elementField.isNullable());
            } else {
                ArrowType.Struct struct = ArrowType.Struct.INSTANCE;
                ArrowType arrowType3 = arrowType;
                if (!(struct != null ? !struct.equals(arrowType3) : arrowType3 != null)) {
                    Buffer fields = (Buffer)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(field.getChildren()).asScala()).map((Function1 & Serializable)child -> {
                        DataType dt = MODULE$.fromArrowField((Field)child);
                        return new StructField(child.getName(), dt, child.isNullable(), StructField$.MODULE$.apply$default$4());
                    });
                    dataType = new StructType((StructField[])fields.toArray(ClassTag$.MODULE$.apply(StructField.class)));
                } else {
                    dataType = this.fromArrowType(arrowType);
                }
            }
        }
        return dataType;
    }

    public Schema toArrowSchema(StructType schema, String timeZoneId, boolean errorOnDuplicatedFieldNames, boolean largeVarTypes) {
        return new Schema((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)schema.map((Function1 & Serializable)field -> MODULE$.toArrowField(field.name(), MODULE$.deduplicateFieldNames(field.dataType(), errorOnDuplicatedFieldNames), field.nullable(), timeZoneId, largeVarTypes))).asJava());
    }

    public boolean toArrowSchema$default$4() {
        return false;
    }

    public StructType fromArrowSchema(Schema schema) {
        return new StructType((StructField[])((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(schema.getFields()).asScala()).map((Function1 & Serializable)field -> {
            DataType dt = MODULE$.fromArrowField((Field)field);
            return new StructField(field.getName(), dt, field.isNullable(), StructField$.MODULE$.apply$default$4());
        })).toArray(ClassTag$.MODULE$.apply(StructField.class)));
    }

    private DataType deduplicateFieldNames(DataType dt, boolean errorOnDuplicatedFieldNames) {
        DataType dataType;
        DataType dataType2;
        while ((dataType2 = dt) instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            dt = userDefinedType.sqlType();
        }
        if (dataType2 instanceof StructType) {
            String[] stringArray;
            StructType structType = (StructType)dataType2;
            StructField[] fields = structType.fields();
            if (Predef$.MODULE$.wrapRefArray((Object[])structType.names()).toSet().size() == structType.names().length) {
                stringArray = structType.names();
            } else {
                if (errorOnDuplicatedFieldNames) {
                    throw ExecutionErrors$.MODULE$.duplicatedFieldNameInArrowStructError((scala.collection.immutable.Seq<String>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)structType.names()));
                }
                Map genNawName = (Map)ArrayOps$.MODULE$.groupBy$extension(Predef$.MODULE$.refArrayOps((Object[])structType.names()), (Function1 & Serializable)x -> (String)Predef$.MODULE$.identity(x)).map((Function1 & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        String name = (String)tuple2._1();
                        String[] names = (String[])tuple2._2();
                        if (names.length > 1) {
                            AtomicInteger i = new AtomicInteger();
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Function0 & Serializable)() -> new StringBuilder(1).append(name).append("_").append(i.getAndIncrement()).toString());
                        }
                    }
                    if (tuple2 == null) throw new MatchError((Object)tuple2);
                    String name = (String)tuple2._1();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Function0 & Serializable)() -> name);
                });
                stringArray = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])structType.names()), (Function1 & Serializable)x$1 -> (String)((Function0)genNawName.apply(x$1)).apply(), ClassTag$.MODULE$.apply(String.class));
            }
            String[] newNames = stringArray;
            StructField[] newFields = (StructField[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.refArrayOps((Object[])fields), (IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])newNames))), (Function1 & Serializable)x0$2 -> {
                String name;
                StructField structField;
                block3: {
                    Tuple2 tuple2;
                    block2: {
                        tuple2 = x0$2;
                        if (tuple2 == null) break block2;
                        structField = (StructField)tuple2._1();
                        name = (String)tuple2._2();
                        if (structField != null) break block3;
                    }
                    throw new MatchError((Object)tuple2);
                }
                DataType dataType = structField.dataType();
                boolean nullable = structField.nullable();
                Metadata metadata = structField.metadata();
                StructField structField2 = new StructField(name, MODULE$.deduplicateFieldNames(dataType, errorOnDuplicatedFieldNames), nullable, metadata);
                return structField2;
            }, ClassTag$.MODULE$.apply(StructField.class));
            dataType = new StructType(newFields);
        } else if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            DataType elementType = arrayType.elementType();
            boolean containsNull = arrayType.containsNull();
            dataType = new ArrayType(this.deduplicateFieldNames(elementType, errorOnDuplicatedFieldNames), containsNull);
        } else if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            boolean valueContainsNull = mapType.valueContainsNull();
            dataType = new MapType(this.deduplicateFieldNames(keyType, errorOnDuplicatedFieldNames), this.deduplicateFieldNames(valueType, errorOnDuplicatedFieldNames), valueContainsNull);
        } else {
            dataType = dt;
        }
        return dataType;
    }

    private ArrowUtils$() {
    }
}

