/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;
import reactor.core.CoreSubscriber;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxTimeout;
import reactor.core.publisher.InternalMonoOperator;
import reactor.core.publisher.Mono;

final class MonoTimeout<T, U, V>
extends InternalMonoOperator<T, T> {
    final Publisher<U> firstTimeout;
    final @Nullable Publisher<? extends T> other;
    final @Nullable String timeoutDescription;
    static final Function NEVER = e -> Flux.never();

    MonoTimeout(Mono<? extends T> source, Publisher<U> firstTimeout, String timeoutDescription) {
        super(source);
        this.firstTimeout = Mono.fromDirect(Objects.requireNonNull(firstTimeout, "firstTimeout"));
        this.other = null;
        this.timeoutDescription = timeoutDescription;
    }

    MonoTimeout(Mono<? extends T> source, Publisher<U> firstTimeout, Publisher<? extends T> other) {
        super(source);
        this.firstTimeout = Mono.fromDirect(Objects.requireNonNull(firstTimeout, "firstTimeout"));
        this.other = Mono.fromDirect(Objects.requireNonNull(other, "other"));
        this.timeoutDescription = null;
    }

    @Override
    public CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super T> actual) {
        return new FluxTimeout.TimeoutMainSubscriber(actual, this.firstTimeout, NEVER, this.other, FluxTimeout.addNameToTimeoutDescription(this.source, this.timeoutDescription));
    }

    @Override
    public @Nullable Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        return super.scanUnsafe(key);
    }
}

