# coding: utf-8

"""
InfluxDB OSS API Service.

The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint.   # noqa: E501

OpenAPI spec version: 2.0.0
Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

from influxdb_client.service._base_service import _BaseService


class OrganizationsService(_BaseService):
    """NOTE: This class is auto generated by OpenAPI Generator.

    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):  # noqa: E501,D401,D403
        """OrganizationsService - a operation defined in OpenAPI."""
        super().__init__(api_client)

    def delete_orgs_id(self, org_id, **kwargs):  # noqa: E501,D401,D403
        """Delete an organization.

        Deletes an organization.  Deleting an organization from InfluxDB Cloud can't be undone. Once deleted, all data associated with the organization is removed.  #### InfluxDB Cloud  - Does the following when you send a delete request:    1. Validates the request and queues the delete.   2. Returns an HTTP `204` status code if queued; _error_ otherwise.   3. Handles the delete asynchronously.  #### InfluxDB OSS  - Validates the request, handles the delete synchronously, and then responds with success or failure.  #### Limitations  - Only one organization can be deleted per request.  #### Related guides  - [Delete organizations](https://docs.influxdata.com/influxdb/latest/organizations/delete-orgs/)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_orgs_id(org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: The ID of the organization to delete. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_orgs_id_with_http_info(org_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_orgs_id_with_http_info(org_id, **kwargs)  # noqa: E501
            return data

    def delete_orgs_id_with_http_info(self, org_id, **kwargs):  # noqa: E501,D401,D403
        """Delete an organization.

        Deletes an organization.  Deleting an organization from InfluxDB Cloud can't be undone. Once deleted, all data associated with the organization is removed.  #### InfluxDB Cloud  - Does the following when you send a delete request:    1. Validates the request and queues the delete.   2. Returns an HTTP `204` status code if queued; _error_ otherwise.   3. Handles the delete asynchronously.  #### InfluxDB OSS  - Validates the request, handles the delete synchronously, and then responds with success or failure.  #### Limitations  - Only one organization can be deleted per request.  #### Related guides  - [Delete organizations](https://docs.influxdata.com/influxdb/latest/organizations/delete-orgs/)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_orgs_id_with_http_info(org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: The ID of the organization to delete. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_orgs_id_prepare(org_id, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/orgs/{orgID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def delete_orgs_id_async(self, org_id, **kwargs):  # noqa: E501,D401,D403
        """Delete an organization.

        Deletes an organization.  Deleting an organization from InfluxDB Cloud can't be undone. Once deleted, all data associated with the organization is removed.  #### InfluxDB Cloud  - Does the following when you send a delete request:    1. Validates the request and queues the delete.   2. Returns an HTTP `204` status code if queued; _error_ otherwise.   3. Handles the delete asynchronously.  #### InfluxDB OSS  - Validates the request, handles the delete synchronously, and then responds with success or failure.  #### Limitations  - Only one organization can be deleted per request.  #### Related guides  - [Delete organizations](https://docs.influxdata.com/influxdb/latest/organizations/delete-orgs/)
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str org_id: The ID of the organization to delete. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_orgs_id_prepare(org_id, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/orgs/{orgID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _delete_orgs_id_prepare(self, org_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['org_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('delete_orgs_id', all_params, local_var_params)
        # verify the required parameter 'org_id' is set
        if ('org_id' not in local_var_params or
                local_var_params['org_id'] is None):
            raise ValueError("Missing the required parameter `org_id` when calling `delete_orgs_id`")  # noqa: E501

        path_params = {}
        if 'org_id' in local_var_params:
            path_params['orgID'] = local_var_params['org_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def delete_orgs_id_members_id(self, user_id, org_id, **kwargs):  # noqa: E501,D401,D403
        """Remove a member from an organization.

        Removes a member from an organization.  Use this endpoint to remove a user's member privileges for an organization. Removing member privileges removes the user's `read` and `write` permissions from the organization.  #### InfluxDB Cloud  - Doesn't use `owner` and `member` roles.   Use [`/api/v2/authorizations`](#tag/Authorizations-(API-tokens)) to assign user permissions.  #### Limitations  - Member permissions are separate from API token permissions. - Member permissions are used in the context of the InfluxDB UI.  #### Required permissions  - `write-orgs INFLUX_ORG_ID`  *`INFLUX_ORG_ID`* is the ID of the organization that you want to remove an owner from.  #### Related guides  - [Manage members](https://docs.influxdata.com/influxdb/latest/organizations/members/)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_orgs_id_members_id(user_id, org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of the user to remove. (required)
        :param str org_id: The ID of the organization to remove a user from. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_orgs_id_members_id_with_http_info(user_id, org_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_orgs_id_members_id_with_http_info(user_id, org_id, **kwargs)  # noqa: E501
            return data

    def delete_orgs_id_members_id_with_http_info(self, user_id, org_id, **kwargs):  # noqa: E501,D401,D403
        """Remove a member from an organization.

        Removes a member from an organization.  Use this endpoint to remove a user's member privileges for an organization. Removing member privileges removes the user's `read` and `write` permissions from the organization.  #### InfluxDB Cloud  - Doesn't use `owner` and `member` roles.   Use [`/api/v2/authorizations`](#tag/Authorizations-(API-tokens)) to assign user permissions.  #### Limitations  - Member permissions are separate from API token permissions. - Member permissions are used in the context of the InfluxDB UI.  #### Required permissions  - `write-orgs INFLUX_ORG_ID`  *`INFLUX_ORG_ID`* is the ID of the organization that you want to remove an owner from.  #### Related guides  - [Manage members](https://docs.influxdata.com/influxdb/latest/organizations/members/)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_orgs_id_members_id_with_http_info(user_id, org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of the user to remove. (required)
        :param str org_id: The ID of the organization to remove a user from. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_orgs_id_members_id_prepare(user_id, org_id, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/orgs/{orgID}/members/{userID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def delete_orgs_id_members_id_async(self, user_id, org_id, **kwargs):  # noqa: E501,D401,D403
        """Remove a member from an organization.

        Removes a member from an organization.  Use this endpoint to remove a user's member privileges for an organization. Removing member privileges removes the user's `read` and `write` permissions from the organization.  #### InfluxDB Cloud  - Doesn't use `owner` and `member` roles.   Use [`/api/v2/authorizations`](#tag/Authorizations-(API-tokens)) to assign user permissions.  #### Limitations  - Member permissions are separate from API token permissions. - Member permissions are used in the context of the InfluxDB UI.  #### Required permissions  - `write-orgs INFLUX_ORG_ID`  *`INFLUX_ORG_ID`* is the ID of the organization that you want to remove an owner from.  #### Related guides  - [Manage members](https://docs.influxdata.com/influxdb/latest/organizations/members/)
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str user_id: The ID of the user to remove. (required)
        :param str org_id: The ID of the organization to remove a user from. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_orgs_id_members_id_prepare(user_id, org_id, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/orgs/{orgID}/members/{userID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _delete_orgs_id_members_id_prepare(self, user_id, org_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['user_id', 'org_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('delete_orgs_id_members_id', all_params, local_var_params)
        # verify the required parameter 'user_id' is set
        if ('user_id' not in local_var_params or
                local_var_params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `delete_orgs_id_members_id`")  # noqa: E501
        # verify the required parameter 'org_id' is set
        if ('org_id' not in local_var_params or
                local_var_params['org_id'] is None):
            raise ValueError("Missing the required parameter `org_id` when calling `delete_orgs_id_members_id`")  # noqa: E501

        path_params = {}
        if 'user_id' in local_var_params:
            path_params['userID'] = local_var_params['user_id']  # noqa: E501
        if 'org_id' in local_var_params:
            path_params['orgID'] = local_var_params['org_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def delete_orgs_id_owners_id(self, user_id, org_id, **kwargs):  # noqa: E501,D401,D403
        """Remove an owner from an organization.

        Removes an [owner](https://docs.influxdata.com/influxdb/latest/reference/glossary/#owner) from the organization.  Organization owners have permission to delete organizations and remove user and member permissions from the organization.  #### InfluxDB Cloud - Doesn't use `owner` and `member` roles.   Use [`/api/v2/authorizations`](#tag/Authorizations-(API-tokens)) to assign user permissions.  #### Limitations  - Owner permissions are separate from API token permissions. - Owner permissions are used in the context of the InfluxDB UI.  #### Required permissions  - `write-orgs INFLUX_ORG_ID`  *`INFLUX_ORG_ID`* is the ID of the organization that you want to remove an owner from.  #### Related endpoints - [Authorizations](#tag/Authorizations-(API-tokens))
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_orgs_id_owners_id(user_id, org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of the user to remove. (required)
        :param str org_id: The ID of the organization to remove an owner from. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_orgs_id_owners_id_with_http_info(user_id, org_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_orgs_id_owners_id_with_http_info(user_id, org_id, **kwargs)  # noqa: E501
            return data

    def delete_orgs_id_owners_id_with_http_info(self, user_id, org_id, **kwargs):  # noqa: E501,D401,D403
        """Remove an owner from an organization.

        Removes an [owner](https://docs.influxdata.com/influxdb/latest/reference/glossary/#owner) from the organization.  Organization owners have permission to delete organizations and remove user and member permissions from the organization.  #### InfluxDB Cloud - Doesn't use `owner` and `member` roles.   Use [`/api/v2/authorizations`](#tag/Authorizations-(API-tokens)) to assign user permissions.  #### Limitations  - Owner permissions are separate from API token permissions. - Owner permissions are used in the context of the InfluxDB UI.  #### Required permissions  - `write-orgs INFLUX_ORG_ID`  *`INFLUX_ORG_ID`* is the ID of the organization that you want to remove an owner from.  #### Related endpoints - [Authorizations](#tag/Authorizations-(API-tokens))
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_orgs_id_owners_id_with_http_info(user_id, org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of the user to remove. (required)
        :param str org_id: The ID of the organization to remove an owner from. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_orgs_id_owners_id_prepare(user_id, org_id, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/orgs/{orgID}/owners/{userID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def delete_orgs_id_owners_id_async(self, user_id, org_id, **kwargs):  # noqa: E501,D401,D403
        """Remove an owner from an organization.

        Removes an [owner](https://docs.influxdata.com/influxdb/latest/reference/glossary/#owner) from the organization.  Organization owners have permission to delete organizations and remove user and member permissions from the organization.  #### InfluxDB Cloud - Doesn't use `owner` and `member` roles.   Use [`/api/v2/authorizations`](#tag/Authorizations-(API-tokens)) to assign user permissions.  #### Limitations  - Owner permissions are separate from API token permissions. - Owner permissions are used in the context of the InfluxDB UI.  #### Required permissions  - `write-orgs INFLUX_ORG_ID`  *`INFLUX_ORG_ID`* is the ID of the organization that you want to remove an owner from.  #### Related endpoints - [Authorizations](#tag/Authorizations-(API-tokens))
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str user_id: The ID of the user to remove. (required)
        :param str org_id: The ID of the organization to remove an owner from. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_orgs_id_owners_id_prepare(user_id, org_id, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/orgs/{orgID}/owners/{userID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _delete_orgs_id_owners_id_prepare(self, user_id, org_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['user_id', 'org_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('delete_orgs_id_owners_id', all_params, local_var_params)
        # verify the required parameter 'user_id' is set
        if ('user_id' not in local_var_params or
                local_var_params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `delete_orgs_id_owners_id`")  # noqa: E501
        # verify the required parameter 'org_id' is set
        if ('org_id' not in local_var_params or
                local_var_params['org_id'] is None):
            raise ValueError("Missing the required parameter `org_id` when calling `delete_orgs_id_owners_id`")  # noqa: E501

        path_params = {}
        if 'user_id' in local_var_params:
            path_params['userID'] = local_var_params['user_id']  # noqa: E501
        if 'org_id' in local_var_params:
            path_params['orgID'] = local_var_params['org_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def get_orgs(self, **kwargs):  # noqa: E501,D401,D403
        """List organizations.

        Lists [organizations](https://docs.influxdata.com/influxdb/latest/reference/glossary/#organization/).  To limit which organizations are returned, pass query parameters in your request. If no query parameters are passed, InfluxDB returns all organizations up to the default `limit`.  #### InfluxDB Cloud  - Only returns the organization that owns the token passed in the request.  #### Related guides  - [View organizations](https://docs.influxdata.com/influxdb/latest/organizations/view-orgs/)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_orgs(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zap_trace_span: OpenTracing span context
        :param int offset: The offset for pagination. The number of records to skip.  For more information about pagination parameters, see [Pagination](https://docs.influxdata.com/influxdb/latest/api/#tag/Pagination).
        :param int limit: Limits the number of records returned. Default is `20`.
        :param bool descending:
        :param str org: An organization name. Only returns the specified organization.
        :param str org_id: An organization ID. Only returns the specified organization.
        :param str user_id: A user ID. Only returns organizations where the specified user is a member or owner.
        :return: Organizations
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_orgs_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_orgs_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_orgs_with_http_info(self, **kwargs):  # noqa: E501,D401,D403
        """List organizations.

        Lists [organizations](https://docs.influxdata.com/influxdb/latest/reference/glossary/#organization/).  To limit which organizations are returned, pass query parameters in your request. If no query parameters are passed, InfluxDB returns all organizations up to the default `limit`.  #### InfluxDB Cloud  - Only returns the organization that owns the token passed in the request.  #### Related guides  - [View organizations](https://docs.influxdata.com/influxdb/latest/organizations/view-orgs/)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_orgs_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zap_trace_span: OpenTracing span context
        :param int offset: The offset for pagination. The number of records to skip.  For more information about pagination parameters, see [Pagination](https://docs.influxdata.com/influxdb/latest/api/#tag/Pagination).
        :param int limit: Limits the number of records returned. Default is `20`.
        :param bool descending:
        :param str org: An organization name. Only returns the specified organization.
        :param str org_id: An organization ID. Only returns the specified organization.
        :param str user_id: A user ID. Only returns organizations where the specified user is a member or owner.
        :return: Organizations
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_orgs_prepare(**kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/orgs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Organizations',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def get_orgs_async(self, **kwargs):  # noqa: E501,D401,D403
        """List organizations.

        Lists [organizations](https://docs.influxdata.com/influxdb/latest/reference/glossary/#organization/).  To limit which organizations are returned, pass query parameters in your request. If no query parameters are passed, InfluxDB returns all organizations up to the default `limit`.  #### InfluxDB Cloud  - Only returns the organization that owns the token passed in the request.  #### Related guides  - [View organizations](https://docs.influxdata.com/influxdb/latest/organizations/view-orgs/)
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str zap_trace_span: OpenTracing span context
        :param int offset: The offset for pagination. The number of records to skip.  For more information about pagination parameters, see [Pagination](https://docs.influxdata.com/influxdb/latest/api/#tag/Pagination).
        :param int limit: Limits the number of records returned. Default is `20`.
        :param bool descending:
        :param str org: An organization name. Only returns the specified organization.
        :param str org_id: An organization ID. Only returns the specified organization.
        :param str user_id: A user ID. Only returns organizations where the specified user is a member or owner.
        :return: Organizations
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_orgs_prepare(**kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/orgs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Organizations',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _get_orgs_prepare(self, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['zap_trace_span', 'offset', 'limit', 'descending', 'org', 'org_id', 'user_id']  # noqa: E501
        self._check_operation_params('get_orgs', all_params, local_var_params)

        if 'offset' in local_var_params and local_var_params['offset'] < 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `offset` when calling `get_orgs`, must be a value greater than or equal to `0`")  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] > 100:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_orgs`, must be a value less than or equal to `100`")  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_orgs`, must be a value greater than or equal to `1`")  # noqa: E501
        path_params = {}

        query_params = []
        if 'offset' in local_var_params:
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'limit' in local_var_params:
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'descending' in local_var_params:
            query_params.append(('descending', local_var_params['descending']))  # noqa: E501
        if 'org' in local_var_params:
            query_params.append(('org', local_var_params['org']))  # noqa: E501
        if 'org_id' in local_var_params:
            query_params.append(('orgID', local_var_params['org_id']))  # noqa: E501
        if 'user_id' in local_var_params:
            query_params.append(('userID', local_var_params['user_id']))  # noqa: E501

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def get_orgs_id(self, org_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve an organization.

        Retrieves an organization.  Use this endpoint to retrieve information for a specific organization.  #### Related guides  - [View organizations](https://docs.influxdata.com/influxdb/latest/organizations/view-orgs/)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_orgs_id(org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: The ID of the organization to retrieve. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Organization
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_orgs_id_with_http_info(org_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_orgs_id_with_http_info(org_id, **kwargs)  # noqa: E501
            return data

    def get_orgs_id_with_http_info(self, org_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve an organization.

        Retrieves an organization.  Use this endpoint to retrieve information for a specific organization.  #### Related guides  - [View organizations](https://docs.influxdata.com/influxdb/latest/organizations/view-orgs/)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_orgs_id_with_http_info(org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: The ID of the organization to retrieve. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Organization
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_orgs_id_prepare(org_id, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/orgs/{orgID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Organization',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def get_orgs_id_async(self, org_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve an organization.

        Retrieves an organization.  Use this endpoint to retrieve information for a specific organization.  #### Related guides  - [View organizations](https://docs.influxdata.com/influxdb/latest/organizations/view-orgs/)
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str org_id: The ID of the organization to retrieve. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Organization
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_orgs_id_prepare(org_id, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/orgs/{orgID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Organization',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _get_orgs_id_prepare(self, org_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['org_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('get_orgs_id', all_params, local_var_params)
        # verify the required parameter 'org_id' is set
        if ('org_id' not in local_var_params or
                local_var_params['org_id'] is None):
            raise ValueError("Missing the required parameter `org_id` when calling `get_orgs_id`")  # noqa: E501

        path_params = {}
        if 'org_id' in local_var_params:
            path_params['orgID'] = local_var_params['org_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def get_orgs_id_members(self, org_id, **kwargs):  # noqa: E501,D401,D403
        """List all members of an organization.

        Lists all users that belong to an organization.  InfluxDB [users](https://docs.influxdata.com/influxdb/latest/reference/glossary/#user) have permission to access InfluxDB.  [Members](https://docs.influxdata.com/influxdb/latest/reference/glossary/#member) are users within the organization.  #### InfluxDB Cloud  - Doesn't use `owner` and `member` roles.   Use [`/api/v2/authorizations`](#tag/Authorizations-(API-tokens)) to assign user permissions.  #### Limitations  - Member permissions are separate from API token permissions. - Member permissions are used in the context of the InfluxDB UI.  #### Required permissions  - `read-orgs INFLUX_ORG_ID`  *`INFLUX_ORG_ID`* is the ID of the organization that you want to retrieve members for.  #### Related guides  - [Manage users](https://docs.influxdata.com/influxdb/latest/users/) - [Manage members](https://docs.influxdata.com/influxdb/latest/organizations/members/)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_orgs_id_members(org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: The ID of the organization to retrieve users for. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMembers
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_orgs_id_members_with_http_info(org_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_orgs_id_members_with_http_info(org_id, **kwargs)  # noqa: E501
            return data

    def get_orgs_id_members_with_http_info(self, org_id, **kwargs):  # noqa: E501,D401,D403
        """List all members of an organization.

        Lists all users that belong to an organization.  InfluxDB [users](https://docs.influxdata.com/influxdb/latest/reference/glossary/#user) have permission to access InfluxDB.  [Members](https://docs.influxdata.com/influxdb/latest/reference/glossary/#member) are users within the organization.  #### InfluxDB Cloud  - Doesn't use `owner` and `member` roles.   Use [`/api/v2/authorizations`](#tag/Authorizations-(API-tokens)) to assign user permissions.  #### Limitations  - Member permissions are separate from API token permissions. - Member permissions are used in the context of the InfluxDB UI.  #### Required permissions  - `read-orgs INFLUX_ORG_ID`  *`INFLUX_ORG_ID`* is the ID of the organization that you want to retrieve members for.  #### Related guides  - [Manage users](https://docs.influxdata.com/influxdb/latest/users/) - [Manage members](https://docs.influxdata.com/influxdb/latest/organizations/members/)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_orgs_id_members_with_http_info(org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: The ID of the organization to retrieve users for. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMembers
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_orgs_id_members_prepare(org_id, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/orgs/{orgID}/members', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='ResourceMembers',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def get_orgs_id_members_async(self, org_id, **kwargs):  # noqa: E501,D401,D403
        """List all members of an organization.

        Lists all users that belong to an organization.  InfluxDB [users](https://docs.influxdata.com/influxdb/latest/reference/glossary/#user) have permission to access InfluxDB.  [Members](https://docs.influxdata.com/influxdb/latest/reference/glossary/#member) are users within the organization.  #### InfluxDB Cloud  - Doesn't use `owner` and `member` roles.   Use [`/api/v2/authorizations`](#tag/Authorizations-(API-tokens)) to assign user permissions.  #### Limitations  - Member permissions are separate from API token permissions. - Member permissions are used in the context of the InfluxDB UI.  #### Required permissions  - `read-orgs INFLUX_ORG_ID`  *`INFLUX_ORG_ID`* is the ID of the organization that you want to retrieve members for.  #### Related guides  - [Manage users](https://docs.influxdata.com/influxdb/latest/users/) - [Manage members](https://docs.influxdata.com/influxdb/latest/organizations/members/)
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str org_id: The ID of the organization to retrieve users for. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMembers
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_orgs_id_members_prepare(org_id, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/orgs/{orgID}/members', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='ResourceMembers',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _get_orgs_id_members_prepare(self, org_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['org_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('get_orgs_id_members', all_params, local_var_params)
        # verify the required parameter 'org_id' is set
        if ('org_id' not in local_var_params or
                local_var_params['org_id'] is None):
            raise ValueError("Missing the required parameter `org_id` when calling `get_orgs_id_members`")  # noqa: E501

        path_params = {}
        if 'org_id' in local_var_params:
            path_params['orgID'] = local_var_params['org_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def get_orgs_id_owners(self, org_id, **kwargs):  # noqa: E501,D401,D403
        """List all owners of an organization.

        Lists all owners of an organization.  #### InfluxDB Cloud  - Doesn't use `owner` and `member` roles.   Use [`/api/v2/authorizations`](#tag/Authorizations-(API-tokens)) to assign user permissions.  #### Required permissions  - `read-orgs INFLUX_ORG_ID`  *`INFLUX_ORG_ID`* is the ID of the organization that you want to retrieve a list of owners from.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_orgs_id_owners(org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: The ID of the organization to list owners for. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwners
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_orgs_id_owners_with_http_info(org_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_orgs_id_owners_with_http_info(org_id, **kwargs)  # noqa: E501
            return data

    def get_orgs_id_owners_with_http_info(self, org_id, **kwargs):  # noqa: E501,D401,D403
        """List all owners of an organization.

        Lists all owners of an organization.  #### InfluxDB Cloud  - Doesn't use `owner` and `member` roles.   Use [`/api/v2/authorizations`](#tag/Authorizations-(API-tokens)) to assign user permissions.  #### Required permissions  - `read-orgs INFLUX_ORG_ID`  *`INFLUX_ORG_ID`* is the ID of the organization that you want to retrieve a list of owners from.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_orgs_id_owners_with_http_info(org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: The ID of the organization to list owners for. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwners
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_orgs_id_owners_prepare(org_id, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/orgs/{orgID}/owners', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='ResourceOwners',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def get_orgs_id_owners_async(self, org_id, **kwargs):  # noqa: E501,D401,D403
        """List all owners of an organization.

        Lists all owners of an organization.  #### InfluxDB Cloud  - Doesn't use `owner` and `member` roles.   Use [`/api/v2/authorizations`](#tag/Authorizations-(API-tokens)) to assign user permissions.  #### Required permissions  - `read-orgs INFLUX_ORG_ID`  *`INFLUX_ORG_ID`* is the ID of the organization that you want to retrieve a list of owners from.
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str org_id: The ID of the organization to list owners for. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwners
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_orgs_id_owners_prepare(org_id, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/orgs/{orgID}/owners', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='ResourceOwners',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _get_orgs_id_owners_prepare(self, org_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['org_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('get_orgs_id_owners', all_params, local_var_params)
        # verify the required parameter 'org_id' is set
        if ('org_id' not in local_var_params or
                local_var_params['org_id'] is None):
            raise ValueError("Missing the required parameter `org_id` when calling `get_orgs_id_owners`")  # noqa: E501

        path_params = {}
        if 'org_id' in local_var_params:
            path_params['orgID'] = local_var_params['org_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def patch_orgs_id(self, org_id, patch_organization_request, **kwargs):  # noqa: E501,D401,D403
        """Update an organization.

        Updates an organization.  Use this endpoint to update properties (`name`, `description`) of an organization.  Updating an organization’s name affects all resources that reference the organization by name, including the following:  - Queries - Dashboards - Tasks - Telegraf configurations - Templates  If you change an organization name, be sure to update the organization name in these resources as well.  #### Related Guides  - [Update an organization](https://docs.influxdata.com/influxdb/latest/organizations/update-org/)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_orgs_id(org_id, patch_organization_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: The ID of the organization to update. (required)
        :param PatchOrganizationRequest patch_organization_request: The organization update to apply. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Organization
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_orgs_id_with_http_info(org_id, patch_organization_request, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_orgs_id_with_http_info(org_id, patch_organization_request, **kwargs)  # noqa: E501
            return data

    def patch_orgs_id_with_http_info(self, org_id, patch_organization_request, **kwargs):  # noqa: E501,D401,D403
        """Update an organization.

        Updates an organization.  Use this endpoint to update properties (`name`, `description`) of an organization.  Updating an organization’s name affects all resources that reference the organization by name, including the following:  - Queries - Dashboards - Tasks - Telegraf configurations - Templates  If you change an organization name, be sure to update the organization name in these resources as well.  #### Related Guides  - [Update an organization](https://docs.influxdata.com/influxdb/latest/organizations/update-org/)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_orgs_id_with_http_info(org_id, patch_organization_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: The ID of the organization to update. (required)
        :param PatchOrganizationRequest patch_organization_request: The organization update to apply. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Organization
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._patch_orgs_id_prepare(org_id, patch_organization_request, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/orgs/{orgID}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Organization',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def patch_orgs_id_async(self, org_id, patch_organization_request, **kwargs):  # noqa: E501,D401,D403
        """Update an organization.

        Updates an organization.  Use this endpoint to update properties (`name`, `description`) of an organization.  Updating an organization’s name affects all resources that reference the organization by name, including the following:  - Queries - Dashboards - Tasks - Telegraf configurations - Templates  If you change an organization name, be sure to update the organization name in these resources as well.  #### Related Guides  - [Update an organization](https://docs.influxdata.com/influxdb/latest/organizations/update-org/)
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str org_id: The ID of the organization to update. (required)
        :param PatchOrganizationRequest patch_organization_request: The organization update to apply. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Organization
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._patch_orgs_id_prepare(org_id, patch_organization_request, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/orgs/{orgID}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Organization',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _patch_orgs_id_prepare(self, org_id, patch_organization_request, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['org_id', 'patch_organization_request', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('patch_orgs_id', all_params, local_var_params)
        # verify the required parameter 'org_id' is set
        if ('org_id' not in local_var_params or
                local_var_params['org_id'] is None):
            raise ValueError("Missing the required parameter `org_id` when calling `patch_orgs_id`")  # noqa: E501
        # verify the required parameter 'patch_organization_request' is set
        if ('patch_organization_request' not in local_var_params or
                local_var_params['patch_organization_request'] is None):
            raise ValueError("Missing the required parameter `patch_organization_request` when calling `patch_orgs_id`")  # noqa: E501

        path_params = {}
        if 'org_id' in local_var_params:
            path_params['orgID'] = local_var_params['org_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        if 'patch_organization_request' in local_var_params:
            body_params = local_var_params['patch_organization_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def post_orgs(self, post_organization_request, **kwargs):  # noqa: E501,D401,D403
        """Create an organization.

        Creates an [organization](https://docs.influxdata.com/influxdb/latest/reference/glossary/#organization) and returns the newly created organization.  #### InfluxDB Cloud  - Doesn't allow you to use this endpoint to create organizations.  #### Related guides  - [Manage organizations](https://docs.influxdata.com/influxdb/latest/organizations)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_orgs(post_organization_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostOrganizationRequest post_organization_request: The organization to create. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Organization
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_orgs_with_http_info(post_organization_request, **kwargs)  # noqa: E501
        else:
            (data) = self.post_orgs_with_http_info(post_organization_request, **kwargs)  # noqa: E501
            return data

    def post_orgs_with_http_info(self, post_organization_request, **kwargs):  # noqa: E501,D401,D403
        """Create an organization.

        Creates an [organization](https://docs.influxdata.com/influxdb/latest/reference/glossary/#organization) and returns the newly created organization.  #### InfluxDB Cloud  - Doesn't allow you to use this endpoint to create organizations.  #### Related guides  - [Manage organizations](https://docs.influxdata.com/influxdb/latest/organizations)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_orgs_with_http_info(post_organization_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostOrganizationRequest post_organization_request: The organization to create. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Organization
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_orgs_prepare(post_organization_request, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/orgs', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Organization',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def post_orgs_async(self, post_organization_request, **kwargs):  # noqa: E501,D401,D403
        """Create an organization.

        Creates an [organization](https://docs.influxdata.com/influxdb/latest/reference/glossary/#organization) and returns the newly created organization.  #### InfluxDB Cloud  - Doesn't allow you to use this endpoint to create organizations.  #### Related guides  - [Manage organizations](https://docs.influxdata.com/influxdb/latest/organizations)
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param PostOrganizationRequest post_organization_request: The organization to create. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Organization
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_orgs_prepare(post_organization_request, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/orgs', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Organization',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _post_orgs_prepare(self, post_organization_request, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['post_organization_request', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('post_orgs', all_params, local_var_params)
        # verify the required parameter 'post_organization_request' is set
        if ('post_organization_request' not in local_var_params or
                local_var_params['post_organization_request'] is None):
            raise ValueError("Missing the required parameter `post_organization_request` when calling `post_orgs`")  # noqa: E501

        path_params = {}

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        if 'post_organization_request' in local_var_params:
            body_params = local_var_params['post_organization_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def post_orgs_id_members(self, org_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        """Add a member to an organization.

        Add a user to an organization.  InfluxDB [users](https://docs.influxdata.com/influxdb/latest/reference/glossary/#user) have permission to access InfluxDB.  [Members](https://docs.influxdata.com/influxdb/latest/reference/glossary/#member) are users within the organization.  #### InfluxDB Cloud - Doesn't use `owner` and `member` roles.   Use [`/api/v2/authorizations`](#tag/Authorizations-(API-tokens)) to assign user permissions.  #### Limitations  - Member permissions are separate from API token permissions. - Member permissions are used in the context of the InfluxDB UI.  #### Required permissions  - `write-orgs INFLUX_ORG_ID`  *`INFLUX_ORG_ID`* is the ID of the organization that you want to add a member to.  #### Related guides  - [Manage users](https://docs.influxdata.com/influxdb/latest/users/) - [Manage members](https://docs.influxdata.com/influxdb/latest/organizations/members/)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_orgs_id_members(org_id, add_resource_member_request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: The ID of the organization. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: The user to add to the organization.  (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMember
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_orgs_id_members_with_http_info(org_id, add_resource_member_request_body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_orgs_id_members_with_http_info(org_id, add_resource_member_request_body, **kwargs)  # noqa: E501
            return data

    def post_orgs_id_members_with_http_info(self, org_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        """Add a member to an organization.

        Add a user to an organization.  InfluxDB [users](https://docs.influxdata.com/influxdb/latest/reference/glossary/#user) have permission to access InfluxDB.  [Members](https://docs.influxdata.com/influxdb/latest/reference/glossary/#member) are users within the organization.  #### InfluxDB Cloud - Doesn't use `owner` and `member` roles.   Use [`/api/v2/authorizations`](#tag/Authorizations-(API-tokens)) to assign user permissions.  #### Limitations  - Member permissions are separate from API token permissions. - Member permissions are used in the context of the InfluxDB UI.  #### Required permissions  - `write-orgs INFLUX_ORG_ID`  *`INFLUX_ORG_ID`* is the ID of the organization that you want to add a member to.  #### Related guides  - [Manage users](https://docs.influxdata.com/influxdb/latest/users/) - [Manage members](https://docs.influxdata.com/influxdb/latest/organizations/members/)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_orgs_id_members_with_http_info(org_id, add_resource_member_request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: The ID of the organization. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: The user to add to the organization.  (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMember
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_orgs_id_members_prepare(org_id, add_resource_member_request_body, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/orgs/{orgID}/members', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='ResourceMember',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def post_orgs_id_members_async(self, org_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        """Add a member to an organization.

        Add a user to an organization.  InfluxDB [users](https://docs.influxdata.com/influxdb/latest/reference/glossary/#user) have permission to access InfluxDB.  [Members](https://docs.influxdata.com/influxdb/latest/reference/glossary/#member) are users within the organization.  #### InfluxDB Cloud - Doesn't use `owner` and `member` roles.   Use [`/api/v2/authorizations`](#tag/Authorizations-(API-tokens)) to assign user permissions.  #### Limitations  - Member permissions are separate from API token permissions. - Member permissions are used in the context of the InfluxDB UI.  #### Required permissions  - `write-orgs INFLUX_ORG_ID`  *`INFLUX_ORG_ID`* is the ID of the organization that you want to add a member to.  #### Related guides  - [Manage users](https://docs.influxdata.com/influxdb/latest/users/) - [Manage members](https://docs.influxdata.com/influxdb/latest/organizations/members/)
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str org_id: The ID of the organization. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: The user to add to the organization.  (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMember
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_orgs_id_members_prepare(org_id, add_resource_member_request_body, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/orgs/{orgID}/members', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='ResourceMember',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _post_orgs_id_members_prepare(self, org_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['org_id', 'add_resource_member_request_body', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('post_orgs_id_members', all_params, local_var_params)
        # verify the required parameter 'org_id' is set
        if ('org_id' not in local_var_params or
                local_var_params['org_id'] is None):
            raise ValueError("Missing the required parameter `org_id` when calling `post_orgs_id_members`")  # noqa: E501
        # verify the required parameter 'add_resource_member_request_body' is set
        if ('add_resource_member_request_body' not in local_var_params or
                local_var_params['add_resource_member_request_body'] is None):
            raise ValueError("Missing the required parameter `add_resource_member_request_body` when calling `post_orgs_id_members`")  # noqa: E501

        path_params = {}
        if 'org_id' in local_var_params:
            path_params['orgID'] = local_var_params['org_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        if 'add_resource_member_request_body' in local_var_params:
            body_params = local_var_params['add_resource_member_request_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def post_orgs_id_owners(self, org_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        """Add an owner to an organization.

        Adds an owner to an organization.  Use this endpoint to assign the organization `owner` role to a user.  #### InfluxDB Cloud  - Doesn't use `owner` and `member` roles.   Use [`/api/v2/authorizations`](#tag/Authorizations-(API-tokens)) to assign user permissions.  #### Required permissions  - `write-orgs INFLUX_ORG_ID`  *`INFLUX_ORG_ID`* is the ID of the organization that you want to add an owner for.  #### Related endpoints  - [Authorizations](#tag/Authorizations-(API-tokens))
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_orgs_id_owners(org_id, add_resource_member_request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: The ID of the organization that you want to add an owner for. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: The user to add as an owner of the organization. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwner
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_orgs_id_owners_with_http_info(org_id, add_resource_member_request_body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_orgs_id_owners_with_http_info(org_id, add_resource_member_request_body, **kwargs)  # noqa: E501
            return data

    def post_orgs_id_owners_with_http_info(self, org_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        """Add an owner to an organization.

        Adds an owner to an organization.  Use this endpoint to assign the organization `owner` role to a user.  #### InfluxDB Cloud  - Doesn't use `owner` and `member` roles.   Use [`/api/v2/authorizations`](#tag/Authorizations-(API-tokens)) to assign user permissions.  #### Required permissions  - `write-orgs INFLUX_ORG_ID`  *`INFLUX_ORG_ID`* is the ID of the organization that you want to add an owner for.  #### Related endpoints  - [Authorizations](#tag/Authorizations-(API-tokens))
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_orgs_id_owners_with_http_info(org_id, add_resource_member_request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: The ID of the organization that you want to add an owner for. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: The user to add as an owner of the organization. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwner
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_orgs_id_owners_prepare(org_id, add_resource_member_request_body, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/orgs/{orgID}/owners', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='ResourceOwner',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def post_orgs_id_owners_async(self, org_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        """Add an owner to an organization.

        Adds an owner to an organization.  Use this endpoint to assign the organization `owner` role to a user.  #### InfluxDB Cloud  - Doesn't use `owner` and `member` roles.   Use [`/api/v2/authorizations`](#tag/Authorizations-(API-tokens)) to assign user permissions.  #### Required permissions  - `write-orgs INFLUX_ORG_ID`  *`INFLUX_ORG_ID`* is the ID of the organization that you want to add an owner for.  #### Related endpoints  - [Authorizations](#tag/Authorizations-(API-tokens))
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str org_id: The ID of the organization that you want to add an owner for. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: The user to add as an owner of the organization. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwner
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_orgs_id_owners_prepare(org_id, add_resource_member_request_body, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/orgs/{orgID}/owners', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='ResourceOwner',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _post_orgs_id_owners_prepare(self, org_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['org_id', 'add_resource_member_request_body', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('post_orgs_id_owners', all_params, local_var_params)
        # verify the required parameter 'org_id' is set
        if ('org_id' not in local_var_params or
                local_var_params['org_id'] is None):
            raise ValueError("Missing the required parameter `org_id` when calling `post_orgs_id_owners`")  # noqa: E501
        # verify the required parameter 'add_resource_member_request_body' is set
        if ('add_resource_member_request_body' not in local_var_params or
                local_var_params['add_resource_member_request_body'] is None):
            raise ValueError("Missing the required parameter `add_resource_member_request_body` when calling `post_orgs_id_owners`")  # noqa: E501

        path_params = {}
        if 'org_id' in local_var_params:
            path_params['orgID'] = local_var_params['org_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        if 'add_resource_member_request_body' in local_var_params:
            body_params = local_var_params['add_resource_member_request_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params
