/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui.wizards;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.modules.autoupdate.ui.wizards.InstallUnitWizardModel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LicenseApprovalPanel
extends JPanel {
    public static final String LICENSE_APPROVED = "license-approved";
    private Map<String, Set<String>> license4plugins;
    private JCheckBox cbAccept;
    private JScrollPane spLicenses;
    private JTextArea taLicenses;
    private JTextArea taTitle;

    public LicenseApprovalPanel(InstallUnitWizardModel installUnitWizardModel, boolean bl) {
        this.initComponents();
        this.cbAccept.setSelected(bl);
        if (installUnitWizardModel != null) {
            this.writeLicenses(installUnitWizardModel);
        } else {
            this.cbAccept.setEnabled(false);
            this.taLicenses.setEnabled(false);
        }
    }

    Collection<String> getLicenses() {
        assert (this.license4plugins != null) : "Licenses must found.";
        if (this.license4plugins == null && this.license4plugins.isEmpty()) {
            return Collections.emptyList();
        }
        return this.license4plugins.keySet();
    }

    private void goOverLicenses(InstallUnitWizardModel installUnitWizardModel) {
        for (UpdateElement updateElement : installUnitWizardModel.getAllUpdateElements()) {
            if (updateElement.getLicence() == null) continue;
            if (this.license4plugins == null) {
                this.license4plugins = new HashMap<String, Set<String>>();
            }
            if (this.license4plugins.containsKey(updateElement.getLicence())) {
                this.license4plugins.get(updateElement.getLicence()).add(updateElement.getDisplayName());
                continue;
            }
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(updateElement.getDisplayName());
            this.license4plugins.put(updateElement.getLicence(), hashSet);
        }
    }

    public boolean isApproved() {
        return this.cbAccept.isSelected();
    }

    private void initComponents() {
        this.taTitle = new JTextArea();
        this.spLicenses = new JScrollPane();
        this.taLicenses = new JTextArea();
        this.cbAccept = new JCheckBox();
        this.taTitle.setEditable(false);
        this.taTitle.setLineWrap(true);
        this.taTitle.setText(NbBundle.getMessage(LicenseApprovalPanel.class, (String)"LicenseApprovalPanel_taTitle_Text"));
        this.taTitle.setWrapStyleWord(true);
        this.taTitle.setMargin(new Insets(0, 4, 0, 0));
        this.taTitle.setOpaque(false);
        this.taLicenses.setColumns(20);
        this.taLicenses.setEditable(false);
        this.taLicenses.setLineWrap(true);
        this.taLicenses.setRows(5);
        this.taLicenses.setWrapStyleWord(true);
        this.taLicenses.setMargin(new Insets(0, 4, 0, 4));
        this.spLicenses.setViewportView(this.taLicenses);
        this.taLicenses.getAccessibleContext().setAccessibleName(NbBundle.getMessage(LicenseApprovalPanel.class, (String)"LicenseApprovalPanel_taLicenses_ACN"));
        this.taLicenses.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(LicenseApprovalPanel.class, (String)"LicenseApprovalPanel_taLicenses_ACD"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbAccept, (String)NbBundle.getMessage(LicenseApprovalPanel.class, (String)"LicenseApprovalPanel.cbAccept.text"));
        this.cbAccept.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LicenseApprovalPanel.this.cbAcceptActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.cbAccept).add(2, (Component)this.taTitle, -1, 461, Short.MAX_VALUE).add((Component)this.spLicenses, -1, 461, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.taTitle, -2, 45, -2).addPreferredGap(0).add((Component)this.spLicenses).addPreferredGap(0).add((Component)this.cbAccept).addContainerGap()));
        this.cbAccept.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(LicenseApprovalPanel.class, (String)"LicenseApprovalPanel_cbAccept_ACN"));
    }

    private void cbAcceptActionPerformed(ActionEvent actionEvent) {
        this.firePropertyChange(LICENSE_APPROVED, null, (Object)this.cbAccept.isSelected());
    }

    private void writeLicenses(InstallUnitWizardModel installUnitWizardModel) {
        this.goOverLicenses(installUnitWizardModel);
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this.license4plugins.keySet()) {
            StringBuffer stringBuffer2 = new StringBuffer();
            for (String string2 : this.license4plugins.get(string)) {
                stringBuffer2.append((stringBuffer2.length() == 0 ? "" : NbBundle.getMessage(LicenseApprovalPanel.class, (String)"LicenseApprovalPanel_tpLicense_Delimeter")) + string2);
            }
            stringBuffer.append(NbBundle.getMessage(LicenseApprovalPanel.class, (String)"LicenseApprovalPanel_tpLicense_Head", (Object)stringBuffer2));
            stringBuffer.append("\n");
            stringBuffer.append(string);
            stringBuffer.append(NbBundle.getMessage(LicenseApprovalPanel.class, (String)"LicenseApprovalPanel_tpLicense_Separator"));
        }
        this.taLicenses.setText(stringBuffer.toString());
        this.taLicenses.setCaretPosition(0);
    }
}

