/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.proxies;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.URI;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.core.proxy.ProxyParam;
import org.parosproxy.paros.core.proxy.ProxyServer;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.OptionsChangedListener;
import org.parosproxy.paros.model.OptionsParam;
import org.zaproxy.zap.extension.proxies.OptionsProxiesPanel;
import org.zaproxy.zap.extension.proxies.ProxiesAPI;
import org.zaproxy.zap.extension.proxies.ProxiesParam;
import org.zaproxy.zap.extension.proxies.ProxiesParamProxy;
import org.zaproxy.zap.utils.ZapXmlConfiguration;

public class ExtensionProxies
extends ExtensionAdaptor
implements OptionsChangedListener {
    public static final String NAME = "ExtensionProxies";
    public static final String ZAP_PROXY_THREAD_PREFIX = "ZAP-";
    private ProxiesParam proxiesParam = null;
    private OptionsProxiesPanel optionsProxiesPanel = null;
    private Map<String, ProxyServer> proxyServers = new HashMap<String, ProxyServer>();
    private static Logger log = LogManager.getLogger(ExtensionProxies.class);

    public ExtensionProxies() {
        this.initialize();
    }

    private void initialize() {
        this.setName(NAME);
        this.setOrder(310);
    }

    @Override
    public boolean supportsDb(String type) {
        return true;
    }

    @Override
    public String getUIName() {
        return Constant.messages.getString("proxies.name");
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        extensionHook.addOptionsParamSet(this.getParam());
        extensionHook.addOptionsChangedListener(this);
        if (this.getView() != null) {
            extensionHook.getHookView().addOptionPanel(this.getOptionsProxiesPanel());
        }
        extensionHook.addApiImplementor(new ProxiesAPI(this));
    }

    @Override
    public void stop() {
        super.stop();
        for (Map.Entry<String, ProxyServer> entry : this.proxyServers.entrySet()) {
            this.stopProxyServer(entry.getKey(), entry.getValue());
        }
        this.proxyServers.clear();
    }

    @Override
    public void start() {
        this.restartProxies();
    }

    @Override
    public void optionsChanged(OptionsParam optionsParam) {
        this.restartProxies();
    }

    private void restartProxies() {
        List<ProxiesParamProxy> proxyParams = this.getParam().getProxies();
        HashMap<String, ProxiesParamProxy> newProxies = new HashMap<String, ProxiesParamProxy>();
        Map<String, ProxyServer> currentProxies = this.proxyServers;
        this.proxyServers = new HashMap<String, ProxyServer>();
        for (ProxiesParamProxy proxiesParamProxy : proxyParams) {
            if (!proxiesParamProxy.isEnabled()) continue;
            String key = ExtensionProxies.createProxyKey(proxiesParamProxy.getAddress(), proxiesParamProxy.getPort());
            ProxyServer proxy = currentProxies.remove(key);
            if (proxy == null) {
                newProxies.put(key, proxiesParamProxy);
                continue;
            }
            ExtensionProxies.applyProxyOptions(proxiesParamProxy, proxy);
            this.proxyServers.put(key, proxy);
        }
        for (Map.Entry entry : currentProxies.entrySet()) {
            this.stopProxyServer((String)entry.getKey(), (ProxyServer)entry.getValue());
        }
        for (Map.Entry entry : newProxies.entrySet()) {
            ProxyServer proxy = this.startProxyServer((ProxiesParamProxy)entry.getValue());
            this.proxyServers.put((String)entry.getKey(), proxy);
        }
    }

    private static void applyProxyOptions(ProxiesParamProxy param, ProxyServer proxyServer) {
        ProxyParam proxyParam = proxyServer.getProxyParam();
        proxyParam.setAlwaysDecodeGzip(param.isAlwaysDecodeGzip());
        proxyParam.setBehindNat(param.isBehindNat());
        proxyParam.setRemoveUnsupportedEncodings(param.isRemoveUnsupportedEncodings());
    }

    private static String createProxyKey(String address, int port) {
        return address + ":" + port;
    }

    private ProxyServer startProxyServer(ProxiesParamProxy param) {
        String address = param.getAddress();
        int port = param.getPort();
        String key = ExtensionProxies.createProxyKey(address, port);
        log.info("Starting alt proxy server: " + key);
        ProxyServer proxyServer = new ProxyServer(ZAP_PROXY_THREAD_PREFIX + key){

            @Override
            public boolean excludeUrl(URI uri) {
                String uriString = uri.toString();
                for (String excludePattern : ExtensionProxies.this.getModel().getOptionsParam().getGlobalExcludeURLParam().getTokensNames()) {
                    if (!uriString.matches(excludePattern)) continue;
                    return true;
                }
                for (String excludePattern : ExtensionProxies.this.getModel().getSession().getExcludeFromProxyRegexs()) {
                    if (!uriString.matches(excludePattern)) continue;
                    return true;
                }
                return false;
            }
        };
        proxyServer.getProxyParam().load(new ZapXmlConfiguration());
        ExtensionProxies.applyProxyOptions(param, proxyServer);
        proxyServer.setConnectionParam(this.getModel().getOptionsParam().getConnectionParam());
        proxyServer.setEnableApi(true);
        Control.getSingleton().getExtensionLoader().addProxyServer(proxyServer);
        proxyServer.startServer(address, port, false);
        return proxyServer;
    }

    private void stopProxyServer(String proxyKey, ProxyServer proxyServer) {
        log.info("Stopping alt proxy server: " + proxyKey);
        proxyServer.stopServer();
        Control.getSingleton().getExtensionLoader().removeProxyServer(proxyServer);
    }

    public List<ProxiesParamProxy> getAdditionalProxies() {
        return this.getParam().getProxies();
    }

    public ProxiesParamProxy getAdditionalProxy(String address, int port) {
        for (ProxiesParamProxy p : this.getParam().getProxies()) {
            if (!p.getAddress().equals(address) || p.getPort() != port) continue;
            return new ProxiesParamProxy(p);
        }
        return null;
    }

    public void addProxy(ProxiesParamProxy proxy) {
        String key = ExtensionProxies.createProxyKey(proxy.getAddress(), proxy.getPort());
        if (this.getAdditionalProxy(proxy.getAddress(), proxy.getPort()) != null) {
            throw new IllegalArgumentException("Proxy already exists: " + key);
        }
        if (!this.canListenOn(proxy.getAddress(), proxy.getPort())) {
            throw new IllegalArgumentException("Cannot listen on: " + key);
        }
        ProxyServer proxyServer = this.startProxyServer(proxy);
        this.proxyServers.put(key, proxyServer);
        this.getParam().addProxy(proxy);
    }

    public void removeProxy(String address, int port) {
        String key = ExtensionProxies.createProxyKey(address, port);
        ProxyServer proxyServer = this.proxyServers.remove(key);
        if (proxyServer == null) {
            throw new IllegalArgumentException("Proxy not found: " + key);
        }
        this.stopProxyServer(key, proxyServer);
        this.getParam().removeProxy(address, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean canListenOn(String address, int port) {
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(port, 5, InetAddress.getByName(address));
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private OptionsProxiesPanel getOptionsProxiesPanel() {
        if (this.optionsProxiesPanel == null) {
            this.optionsProxiesPanel = new OptionsProxiesPanel(this);
        }
        return this.optionsProxiesPanel;
    }

    private ProxiesParam getParam() {
        if (this.proxiesParam == null) {
            this.proxiesParam = new ProxiesParam();
        }
        return this.proxiesParam;
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    @Override
    public String getDescription() {
        return Constant.messages.getString("proxies.desc");
    }

    static boolean isSameAddress(String address, String otherAddress) {
        if (address.equals(otherAddress)) {
            return true;
        }
        try {
            return InetAddress.getByName(address).equals(InetAddress.getByName(otherAddress));
        }
        catch (UnknownHostException e) {
            return false;
        }
    }
}

