/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.extensions.cd;

import java.util.List;
import org.aesh.command.Command;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandResult;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.option.Arguments;
import org.aesh.command.option.Option;
import org.aesh.io.Resource;
import org.aesh.readline.Prompt;
import org.aesh.utils.Config;

@CommandDefinition(name="cd", description="change directory [dir]")
public class Cd
implements Command<CommandInvocation> {
    @Option(shortName=104, name="help", hasValue=false, description="display this help and exit")
    private boolean help;
    @Arguments(description="directory to change to")
    private List<Resource> arguments;

    @Override
    public CommandResult execute(CommandInvocation commandInvocation) {
        if (this.help) {
            commandInvocation.println(commandInvocation.getHelpInfo("cd"));
            return CommandResult.SUCCESS;
        }
        if (this.arguments == null) {
            this.updatePrompt(commandInvocation, commandInvocation.getConfiguration().getAeshContext().getCurrentWorkingDirectory().newInstance(Config.getHomeDir()));
        } else {
            List<Resource> files = this.arguments.get(0).resolve(commandInvocation.getConfiguration().getAeshContext().getCurrentWorkingDirectory());
            if (files.get(0).isDirectory()) {
                this.updatePrompt(commandInvocation, files.get(0));
            }
        }
        return CommandResult.SUCCESS;
    }

    private void updatePrompt(CommandInvocation commandInvocation, Resource file) {
        commandInvocation.getConfiguration().getAeshContext().setCurrentWorkingDirectory(file);
        commandInvocation.setPrompt(new Prompt("[aesh@extensions:" + file.toString() + "]$ "));
    }
}

