/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import java.io.Serializable;
import org.gradle.api.Action;
import org.gradle.api.internal.MutationGuard;
import org.gradle.api.internal.lambdas.SerializableLambdas;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.internal.exceptions.Contextual;

public class DefaultMutationGuard
implements MutationGuard {
    private final ThreadLocal<Boolean> mutationGuardState = ThreadLocal.withInitial(SerializableLambdas.supplier((SerializableLambdas.SerializableSupplier & Serializable)() -> true));

    @Override
    public <T> Action<? super T> wrapLazyAction(Action<? super T> action) {
        return this.newActionWithMutation(action, false);
    }

    @Override
    public <T> Action<? super T> wrapEagerAction(Action<? super T> action) {
        return this.newActionWithMutation(action, true);
    }

    @Override
    public boolean isLazyContext() {
        boolean mutationAllowed = this.mutationGuardState.get();
        this.removeThreadLocalStateIfMutationAllowed(mutationAllowed);
        return !mutationAllowed;
    }

    @Override
    public void assertEagerContext(String methodName, Object target) {
        if (this.isLazyContext()) {
            throw DefaultMutationGuard.createIllegalStateException(new DslObject(target).getPublicType().getConcreteClass(), methodName, target);
        }
    }

    @Override
    public <T> void assertEagerContext(String methodName, T target, Class<T> targetType) {
        if (this.isLazyContext()) {
            throw DefaultMutationGuard.createIllegalStateException(targetType, methodName, target);
        }
    }

    private <T> Action<? super T> newActionWithMutation(final Action<? super T> action, final boolean allowMutationMethods) {
        return new Action<T>(){

            public void execute(T t) {
                boolean oldIsMutationAllowed = (Boolean)DefaultMutationGuard.this.mutationGuardState.get();
                DefaultMutationGuard.this.mutationGuardState.set(allowMutationMethods);
                try {
                    action.execute(t);
                }
                finally {
                    DefaultMutationGuard.this.setMutationGuardState(oldIsMutationAllowed);
                }
            }
        };
    }

    private void setMutationGuardState(boolean newState) {
        if (newState) {
            this.removeThreadLocalStateIfMutationAllowed(true);
        } else {
            this.mutationGuardState.set(false);
        }
    }

    private void removeThreadLocalStateIfMutationAllowed(boolean mutationAllowed) {
        if (mutationAllowed) {
            this.mutationGuardState.remove();
        }
    }

    private static <T> IllegalStateException createIllegalStateException(Class<T> targetType, String methodName, T target) {
        return new IllegalMutationException(String.format("%s#%s on %s cannot be executed in the current context.", targetType.getSimpleName(), methodName, target));
    }

    @Contextual
    private static class IllegalMutationException
    extends IllegalStateException {
        public IllegalMutationException(String message) {
            super(message);
        }
    }
}

