untrusted comment: verify with openbsd-65-base.pub
RWSZaRmt1LEQT3wedoV4T9zhPhNcSRgiIxcMLQbgSQGPaf/XtaBIqfdClb4h58JkXdPNTDCIoyhhhMTz1edTYlkwr3ZQPo0zvAM=

OpenBSD 6.5 errata 013, October 5, 2019

Specially crafted queries may crash unwind and unbound.

Apply by doing:
    signify -Vep /etc/signify/openbsd-65-base.pub -x 013_unbound.patch.sig \
	-m - | (cd /usr/src && patch -p0)

And then rebuild and install unwind and unbound:

    cd /usr/src/sbin/unwind
    make obj
    make
    make install

    cd /usr/src/usr.sbin/unbound
    make -f Makefile.bsd-wrapper obj
    make -f Makefile.bsd-wrapper
    make -f Makefile.bsd-wrapper install

Index: sbin/unwind/libunbound/util/data/msgparse.c
===================================================================
RCS file: /cvs/src/sbin/unwind/libunbound/util/data/msgparse.c,v
retrieving revision 1.1
diff -u -p -r1.1 msgparse.c
--- sbin/unwind/libunbound/util/data/msgparse.c	23 Jan 2019 13:05:27 -0000	1.1
+++ sbin/unwind/libunbound/util/data/msgparse.c	3 Oct 2019 11:55:54 -0000
@@ -1061,18 +1061,18 @@ parse_edns_from_pkt(sldns_buffer* pkt, s
 	size_t rdata_len;
 	uint8_t* rdata_ptr;
 	log_assert(LDNS_QDCOUNT(sldns_buffer_begin(pkt)) == 1);
+	memset(edns, 0, sizeof(*edns));
 	if(LDNS_ANCOUNT(sldns_buffer_begin(pkt)) != 0 ||
 		LDNS_NSCOUNT(sldns_buffer_begin(pkt)) != 0) {
 		if(!skip_pkt_rrs(pkt, ((int)LDNS_ANCOUNT(sldns_buffer_begin(pkt)))+
 			((int)LDNS_NSCOUNT(sldns_buffer_begin(pkt)))))
-			return 0;
+			return LDNS_RCODE_FORMERR;
 	}
 	/* check edns section is present */
 	if(LDNS_ARCOUNT(sldns_buffer_begin(pkt)) > 1) {
 		return LDNS_RCODE_FORMERR;
 	}
 	if(LDNS_ARCOUNT(sldns_buffer_begin(pkt)) == 0) {
-		memset(edns, 0, sizeof(*edns));
 		edns->udp_size = 512;
 		return 0;
 	}
Index: usr.sbin/unbound/util/data/msgparse.c
===================================================================
RCS file: /cvs/src/usr.sbin/unbound/util/data/msgparse.c,v
retrieving revision 1.5
diff -u -p -r1.5 msgparse.c
--- usr.sbin/unbound/util/data/msgparse.c	17 Sep 2018 09:46:12 -0000	1.5
+++ usr.sbin/unbound/util/data/msgparse.c	3 Oct 2019 11:47:53 -0000
@@ -1061,18 +1061,18 @@ parse_edns_from_pkt(sldns_buffer* pkt, s
 	size_t rdata_len;
 	uint8_t* rdata_ptr;
 	log_assert(LDNS_QDCOUNT(sldns_buffer_begin(pkt)) == 1);
+	memset(edns, 0, sizeof(*edns));
 	if(LDNS_ANCOUNT(sldns_buffer_begin(pkt)) != 0 ||
 		LDNS_NSCOUNT(sldns_buffer_begin(pkt)) != 0) {
 		if(!skip_pkt_rrs(pkt, ((int)LDNS_ANCOUNT(sldns_buffer_begin(pkt)))+
 			((int)LDNS_NSCOUNT(sldns_buffer_begin(pkt)))))
-			return 0;
+			return LDNS_RCODE_FORMERR;
 	}
 	/* check edns section is present */
 	if(LDNS_ARCOUNT(sldns_buffer_begin(pkt)) > 1) {
 		return LDNS_RCODE_FORMERR;
 	}
 	if(LDNS_ARCOUNT(sldns_buffer_begin(pkt)) == 0) {
-		memset(edns, 0, sizeof(*edns));
 		edns->udp_size = 512;
 		return 0;
 	}
