untrusted comment: verify with openbsd-65-base.pub
RWSZaRmt1LEQT7mYoxh80XxHd1J6eeWZM9356VATex5CppmV+pRcd8wwFqzwZSkgqH1v6d6Dic47Xx1/ZUZbeUYXaWsKPmIFMwo=

OpenBSD 6.5 errata 017, November 16, 2019:

A regular user could change some network interface parameters due
to missing checks in the ioctl(2) system call.

Apply by doing:
    signify -Vep /etc/signify/openbsd-65-base.pub -x 017_ifioctl.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/dev/ic/an.c
===================================================================
RCS file: /cvs/src/sys/dev/ic/an.c,v
retrieving revision 1.73
diff -u -p -r1.73 an.c
--- sys/dev/ic/an.c	19 Feb 2018 08:59:52 -0000	1.73
+++ sys/dev/ic/an.c	14 Nov 2019 14:51:56 -0000
@@ -902,6 +902,8 @@ an_ioctl(struct ifnet *ifp, u_long comma
 		error = 0;
 		break;
 	case SIOCS80211NWKEY:
+		if ((error = suser(curproc)) != 0)
+			break;
 		error = an_set_nwkey(sc, (struct ieee80211_nwkey *)data);
 			break;
 	case SIOCG80211NWKEY:
Index: sys/net/if.c
===================================================================
RCS file: /cvs/src/sys/net/if.c,v
retrieving revision 1.574
diff -u -p -r1.574 if.c
--- sys/net/if.c	10 Apr 2019 09:51:35 -0000	1.574
+++ sys/net/if.c	14 Nov 2019 14:51:56 -0000
@@ -2169,6 +2169,7 @@ ifioctl(struct socket *so, u_long cmd, c
 	case SIOCDELMULTI:
 	case SIOCSIFMEDIA:
 	case SIOCSVNETID:
+	case SIOCDVNETID:
 	case SIOCSVNETFLOWID:
 	case SIOCSTXHPRIO:
 	case SIOCSIFPAIR:
@@ -2181,6 +2182,33 @@ ifioctl(struct socket *so, u_long cmd, c
 	case SIOCSPWE3FAT:
 	case SIOCSPWE3NEIGHBOR:
 	case SIOCDPWE3NEIGHBOR:
+#if NBRIDGE > 0
+	case SIOCBRDGADD:
+	case SIOCBRDGDEL:
+	case SIOCBRDGSIFFLGS:
+	case SIOCBRDGSCACHE:
+	case SIOCBRDGADDS:
+	case SIOCBRDGDELS:
+	case SIOCBRDGSADDR:
+	case SIOCBRDGSTO:
+	case SIOCBRDGDADDR:
+	case SIOCBRDGFLUSH:
+	case SIOCBRDGADDL:
+	case SIOCBRDGSIFPROT:
+	case SIOCBRDGARL:
+	case SIOCBRDGFRL:
+	case SIOCBRDGSPRI:
+	case SIOCBRDGSHT:
+	case SIOCBRDGSFD:
+	case SIOCBRDGSMA:
+	case SIOCBRDGSIFPRIO:
+	case SIOCBRDGSIFCOST:
+	case SIOCBRDGSTXHC:
+	case SIOCBRDGSPROTO:
+	case SIOCSWGDPID:
+	case SIOCSWSPORTNO:
+	case SIOCSWGMAXFLOW:
+#endif
 		if ((error = suser(p)) != 0)
 			break;
 		/* FALLTHROUGH */
@@ -2188,11 +2216,30 @@ ifioctl(struct socket *so, u_long cmd, c
 		error = ((*so->so_proto->pr_usrreq)(so, PRU_CONTROL,
 			(struct mbuf *) cmd, (struct mbuf *) data,
 			(struct mbuf *) ifp, p));
-		if (error == EOPNOTSUPP) {
-			NET_LOCK();
-			error = ((*ifp->if_ioctl)(ifp, cmd, data));
-			NET_UNLOCK();
+		if (error != EOPNOTSUPP)
+			break;
+		switch (cmd) {
+		case SIOCAIFADDR:
+		case SIOCDIFADDR:
+		case SIOCSIFADDR:
+		case SIOCSIFNETMASK:
+		case SIOCSIFDSTADDR:
+		case SIOCSIFBRDADDR:
+#ifdef INET6
+		case SIOCAIFADDR_IN6:
+		case SIOCDIFADDR_IN6:
+#endif
+			error = suser(p);
+			break;
+		default:
+			error = 0;
+			break;
 		}
+		if (error)
+			break;
+		NET_LOCK();
+		error = ((*ifp->if_ioctl)(ifp, cmd, data));
+		NET_UNLOCK();
 		break;
 	}
 
Index: sys/net/if_spppsubr.c
===================================================================
RCS file: /cvs/src/sys/net/if_spppsubr.c,v
retrieving revision 1.174
diff -u -p -r1.174 if_spppsubr.c
--- sys/net/if_spppsubr.c	19 Feb 2018 08:59:52 -0000	1.174
+++ sys/net/if_spppsubr.c	14 Nov 2019 14:51:57 -0000
@@ -873,6 +873,8 @@ sppp_ioctl(struct ifnet *ifp, u_long cmd
 		break;
 
 	case SIOCSSPPPPARAMS:
+		if ((rv = suser(curproc)) != 0)
+			break;
 		rv = sppp_set_params(sp, ifr);
 		break;
 
