untrusted comment: verify with openbsd-72-base.pub
RWQTKNnK3CZZ8BpZmfrQRq2F0DAhW6dxBSUKYtuqw3xcqBllvEsr7g3ZDLgB0T2zx/+fb509DjF9XHjo/kCSMuoKHqcNryx14wo=

OpenBSD 7.2 errata 001, October 24, 2022:

Custom verification callbacks could cause the X.509 verifier to fail
to store errors resulting from leaf certificate verification.

Apply by doing:
    signify -Vep /etc/signify/openbsd-72-base.pub -x 001_x509.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install libcrypto and unwind:
    cd /usr/src/lib/libcrypto
    make obj
    make includes
    make
    make install

Index: lib/libcrypto/x509/x509_verify.c
===================================================================
RCS file: /cvs/src/lib/libcrypto/x509/x509_verify.c,v
retrieving revision 1.60
diff -u -p -r1.60 x509_verify.c
--- lib/libcrypto/x509/x509_verify.c	5 Aug 2022 14:46:52 -0000	1.60
+++ lib/libcrypto/x509/x509_verify.c	18 Oct 2022 08:32:25 -0000
@@ -494,6 +494,15 @@ x509_verify_ctx_add_chain(struct x509_ve
 	if (!x509_verify_ctx_validate_legacy_chain(ctx, chain, depth))
 		return 0;
 
+	/* Verify the leaf certificate and store any resulting error. */
+	if (!x509_verify_cert_valid(ctx, leaf, NULL))
+		return 0;
+	if (!x509_verify_cert_hostname(ctx, leaf, name))
+		return 0;
+	if (ctx->error_depth == 0 &&
+	    ctx->error != X509_V_ERR_UNABLE_TO_GET_ISSUER_CERT_LOCALLY)
+		chain->cert_errors[0] = ctx->error;
+
 	/*
 	 * In the non-legacy code, extensions and purpose are dealt
 	 * with as the chain is built.
@@ -508,16 +517,11 @@ x509_verify_ctx_add_chain(struct x509_ve
 		return x509_verify_cert_error(ctx, last, depth,
 		    X509_V_ERR_OUT_OF_MEM, 0);
 	}
-
-	if (!x509_verify_cert_valid(ctx, leaf, NULL))
-		return 0;
-
-	if (!x509_verify_cert_hostname(ctx, leaf, name))
-		return 0;
-
 	ctx->chains_count++;
+
 	ctx->error = X509_V_OK;
 	ctx->error_depth = depth;
+
 	return 1;
 }
 
